#ifndef HINT_MANAGER_H
#define HINT_MANAGER_H

#include <qframe.h>
#include <qtimer.h>
#include <qlayout.h>
#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <qpoint.h>

#include "gadu.h"
#include "hint.h"
#include "hint_manager_slots.h"
#include "../notify/notify.h"

class HintManager : public Notifier
{
	Q_OBJECT

	private:
		QFrame *frame;
		HintManagerSlots *hint_manager_slots;
		QTimer *hint_timer;
		QGridLayout *grid;
		QPtrList<Hint> hints;
		QFrame *tipFrame;

		/**
			ustala rg, od ktrego bdzie liczona pozycja grupy dymkw
		**/
		void setGridOrigin();

	private slots:
		/**
			mina sekunda: aktualizuje czasy wszystkich dymkw
			usuwa te, ktrym min czas
		**/
		void oneSecond();

		/**
			przesuwa ca grup hintw zgodnie z preferowanym rozmiarem grupy
			i wykryt/okrelon w konfiguracji pozycj traya
		**/
		void setHint();

		/**
			na dymku o numerze id kliknito lewym przyciskiem myszy
			w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
		**/
		void leftButtonSlot(unsigned int id);

		/**
			na dymku o numerze id kliknito prawym przyciskiem myszy
			w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
		**/
		void rightButtonSlot(unsigned int id);

		/**
			na dymku o numerze id kliknito rodkowym przyciskiem myszy
			w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
		**/
		void midButtonSlot(unsigned int id);

	public slots:
/*********** sloty dla notify ************/
		/* nowa rozmowa */
		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);

		/* nowa wiadomo w oknie chat */
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);

		/* bd poczenia */
		void connectionError(Protocol *protocol, const QString &message);

		/* uytkownik zmieni status */
		void userStatusChanged(UserListElement ule, QString protocolName, const UserStatus &oldStatus);

		/* uytkownik zmieni status na "Dostpny" */
		void userChangedStatusToAvailable(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Zaraz wracam" */
		void userChangedStatusToBusy(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Niewidoczny" */
		void userChangedStatusToInvisible(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Niewidoczny" lub "Niedostpny" */
		void userChangedStatusToNotAvailable(const QString &protocolName, UserListElement);

		void userBoxChangeToolTip(const QPoint &point, UserListElement user, bool show);

		/* inna informacja do powiadomienia */
		/* jeeli parameters == NULL, to brane s domylne ustawienia dymkw typu message
		 * w przeciwnym razie z mapy brane s nastpujce wartoci:
		 *		"Pixmap"           - QPixmap
		 *		"Font"             - QFont
		 *		"Foreground color" - QColor
		 *		"Background color" - QColor
		 *		"Timeout"          - unsigned int
		 *		"ShowSource"       - bool
		 * jeeli ktra z wartoci jest nieokrelona, to dla niej brana jest warto domylna
		 * gdy UserListElement != NULL, to jego uin brany jest do tworzenia dymka (LMB np otwiera okno rozmowy z danym uinem)
		 */
		void message(const QString &from, const QString &message, const QMap<QString, QVariant> *parameters, const UserListElement *ule);
		virtual void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules);
/*********** koniec slotw dla notify *************/

		/**
			pokazuje nowy dymek o treci "text", obrazku "pixmap",
			czcionk "font" o kolorze "fgcolor", tle "bgcolor",
			czasie zaniku "timeout" (sekund), dotyczcy "senders"

			pozostae funkcje pokazujce dymki s tylko opakowaniami na t funkcj
		**/
		void addHint(const QString &text, const QPixmap &pixmap, const QFont &font, const QColor &fgcolor, const QColor &bgcolor, unsigned int timeout, const UserListElements &senders = UserListElements());

		/**
			usuwa dymek o numerze id
		**/
		void deleteHint(unsigned int id);

		/**
			jeeli dymek dotyczy konkrentej osoby lub grupy osb, to otwierane jest okno chatu
			dymek jest kasowany
		**/
		void openChat(unsigned int id);

		/**
			usuwa wszystkie dymki
		**/
		void deleteAllHints();


	signals:
		/**
			HintManager szuka pozycji traya, aby wywietli w jego okolicy dymki
		**/
		void searchingForTrayPosition(QPoint& pos);

	public:
		HintManager(QWidget *parent=0, const char *name=0);
		~HintManager();
};

extern HintManager *hint_manager;

#endif
