/*
		       Recycle Bin Desktop Icon
 */

#ifndef RECBINDESKICON_H
#define RECBINDESKICON_H

#include <gtk/gtk.h>
#include "desktop_icon.h"
#include "edv_types.h"


typedef struct _edv_recbin_desktop_icon_struct edv_recbin_desktop_icon_struct;
#define EDV_RECBIN_DESKTOP_ICON(p)	((edv_recbin_desktop_icon_struct *)(p))


/*
 *	Recycle Bin Desktop Icon:
 */
struct _edv_recbin_desktop_icon_struct {

	desktop_icon_struct	*deskicon;
	edv_core_struct	*core;

	/* Last known items in recycle bin, this is used as a quick
	 * access value to check if the recycle bin has contents or
	 * not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

};


extern edv_recbin_desktop_icon_struct *EDVRecBinDeskIconNew(
	edv_core_struct *core
);
extern void EDVRecBinDeskIconUpdate(edv_recbin_desktop_icon_struct *rbdi);
extern void EDVRecBinDeskIconMap(edv_recbin_desktop_icon_struct *rbdi);
extern void EDVRecBinDeskIconUnmap(edv_recbin_desktop_icon_struct *rbdi);
extern void EDVRecBinDeskIconDelete(edv_recbin_desktop_icon_struct *rbdi);


#endif	/* RECBINDESKICON_H */
