SSLCLIENT(1)                 DACS Commands Manual                 SSLCLIENT(1)



[1mNAME[0m
       sslclient - an SSL client

[1mSYNOPSIS[0m
       [1msslclient [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-caf [22m| [1m--ca_cert_file [4m[22mfilename[24m]
                 [[1m-cad [22m| [1m--ca_cert_dir [4m[22mdirname[24m]
                 [[1m-ccf [22m| [1m--cert_chain_file [4m[22mfilename[24m]
                 [[1m-C [22m| [1m--ciphers [4m[22mcipherstring[24m]
                 [[[1m-dvp[22m] | [[1m--default_verify_paths[22m] [4mcipherstring[24m]
                 [[1m-h [22m| [1m--help[22m] [[1m-kf [22m| [1m--key_file [4m[22mfilename[24m]
                 [[1m-kft [22m| [1m--key_file_type [22mpem | asn1]
                 [[1m-p [22m| [1m-sp [22m| [[1m--server_port[22m] [4mportnum[24m]
                 [[1m-r [22m| [1m--random [4m[22mfilename[24m]
                 [[[1m-sm [22m| [1m--server_match [4m[22mregex[24m ]...]
                 [[1m-vd [22m| [1m--verify_depth [4m[22mdepth[24m]
                 [[1m-vt [22m| [1m--verify_type [22mnone | peer] [[1m--[22m] [4mserver[24m [:[4mport[24m ]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite. It can be used with the usual
       [1mDACS [22mcommand line options ([34m[1mdacsoptions[0m[1m[22m[1]), [4mprovided[24m [4mthey[24m [4mall[24m [4mappear[0m
       [4mbefore[24m [4mthe[24m [4mprogram-specific[24m [4mflags[24m (note that the [1m-un [22mflag can be used
       to suppress configuration file processing).  [1msslclient [22mis also used by
       the [34m[1mhttp(1)[0m[1m[22m[2] command and by requests generated internally by [1mDACS[0m
       components.

       The [1msslclient [22mutility acts as an SSL client. After establishing a
       bidirectional SSL connection with an SSL server, it forwards its
       standard input to the SSL server and writes data produced by the SSL
       server to [1msslclient's [22mstandard output.

       [1msslclient [22mconnects to [4mserver[24m (a domain name or IP address). If a port
       number suffix is given ([4mport[24m), it is used; otherwise, if a port number
       is specified as a separate command line argument ([1m--server_port[0m
       [4mportnum[24m), that is used; failing that, the [34m[1mdefault SSL port for https[0m
       [1m[34m(443)[0m[1m[22m[3] is used.

       The program reads from its standard input and the server asynchronously
       (using non-blocking I/O). Note that the server side might need to see
       end-of-file on its input before its output is returned to [1msslclient[22m.

       This program's underlying SSL functionality is provided by [34m[1mOpenSSL[0m[1m[22m[4].

[1mOPTIONS[0m
       [1msslclient [22mrecognizes these options:

       [1m-caf [4m[22mfilename[0m
       [1m--ca_cert_file [4m[22mfilename[0m
           This identifies [4mfilename[24m as a file of CA certificates in PEM
           format. This is the [4mCAfile[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4]
           [34m[1mSSL_CTX_load_verify_locations()[0m[1m[22m[5] function. It is similar to
           [34m[1mmod_ssl's[0m[1m[22m[6] [34m[1mSSLCACertificateFile[0m[1m[22m[7] directive, except that it is
           used to verify the server's SSL certificate.

       [1m-cad [4m[22mdirname[0m
       [1m--ca_cert_dir [4m[22mdirname[0m
           This identifies [4mdirname[24m as a directory containing CA certificates
           in PEM format, one certificate per file. This is the [4mCApath[0m
           argument to the [34m[1mOpenSSL[0m[1m[22m[4] [34m[1mSSL_CTX_load_verify_locations()[0m[1m[22m[5]
           function. It is similar to [34m[1mmod_ssl's[0m[1m[22m[6] [34m[1mSSLCACertificatePath[0m[1m[22m[8]
           directive, except that it is used to verify the server's
           certificate.

       [1m-ccf [4m[22mfilename[0m
       [1m--cert_chain_file [4m[22mfilename[0m
           This causes the client certificate chain to be loaded from
           [4mfilename[24m, a file containing certificates in PEM format. This is the
           [4mfile[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4]
           [34m[1mSSL_CTX_use_certificate_chain_file()[0m[1m[22m[9] function. It is similar to
           [34m[1mmod_ssl's[0m[1m[22m[6] [34m[1mSSLCACertificateChainFile[0m[1m[22m[10] directive, except that
           it is used for the client's chain.

               [1mTip[0m
               If you want the client certificate to be sent you must also
               specify the [1m-kf [22mflag.

       [1m-C [4m[22mcipherstring[0m
       [1m--ciphers [4m[22mcipherstring[0m
           This sets the list of ciphers to be used to [4mcipherstring[24m. This is
           the [4mstr[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4] [34m[1mSSL_CTX_set_cipher_list()[0m[1m[22m[11]
           function. It is similar to [34m[1mmod_ssl's[0m[1m[22m[6] [34m[1mSSLCipherSuite[0m[1m[22m[12]
           directive.

       [1m-dvp[0m
       [1m--default_verify_paths[0m
           This flag tells [1msslclient [22mto use default locations for finding CA
           certificates. It results in a call to the [34m[1mOpenSSL[0m[1m[22m[4]
           [1mSSL_CTX_set_default_verify_paths() [22mfunction.

       [1m-h[0m
       [1m--help[0m
           Print a usage synopsis.

       [1m-kf [4m[22mfilename[0m
       [1m--key_file [4m[22mfilename[0m
           This sets [1msslclient's [22mprivate key to the first private key found in
           [4mfilename[24m. This is the [4mfile[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4]
           [1mSSL_CTX_usePrivateKey_file() [22mfunction. The default private key file
           type is PEM. If the key has been encrypted, the program will prompt
           for the passphrase.

       [1m-kft [4m[22mtype[0m
       [1m--key_file_type [4m[22mtype[0m
           The private key file type is set to [4mtype[24m, which must be either pem
           or asn1 (case insensitive). The default private key file type is
           PEM.

       [1m-p [4m[22mportnum[0m
       [1m-sp [4m[22mportnum[0m
       [1m--server_port [4m[22mportnum[0m
           Unless appended to the [4mserver[24m argument, [4mportnum[24m is the port number
           to use, overriding the default port (443).

       [1m-r [4m[22mfilename[0m
       [1m--random [4m[22mfilename[0m
           Seed material for the PRNG is read from [4mfilename[24m. This is the
           [4mfilename[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4] [1mRAND_load_file() [22mfunction.

       [1m-sm [4m[22mregex[0m
       [1m--server_match [4m[22mregex[0m
           This argument, which may be repeated, specifies a constraint on the
           server's identity by matching an attribute value in the server's
           certificate against [4mregex[24m. These tests are made immediately after
           an SSL connection is established. Each [4mregex[24m is an IEEE Std 1003.2
           ("POSIX.2") regular expression with extended expressions and case
           insensitivity (REG_EXTENDED | REG_ICASE). See [34m[1mbelow[0m[1m[22m[13] for the
           matching algorithm.

       [1m-vd [4m[22mdepth[0m
       [1m--verify_depth [4m[22mdepth[0m
           This sets the maximum depth for certificate chain verification to
           [4mdepth[24m. This is the [4mdepth[24m argument to the [34m[1mOpenSSL[0m[1m[22m[4]
           [1mSSL_CTX_set_verify_depth() [22mfunction.

       [1m-vt [4m[22mtype[0m
       [1m--verify_type [4m[22mtype[0m
           This sets the verification mode to [4mtype[24m, which must be either none
           or peer (case insensitive). This is the [4mmode[24m argument to the
           [34m[1mOpenSSL[0m[1m[22m[4] [1mSSL_CTX_set_verify() [22mfunction.

       [1m--[0m
           This argument explicitly marks the end of the flags.

       The [1mDACS -v [22m(or [1m--verbose[22m) flag causes the program to show some of the
       server's SSL certificate, print feedback about regular expression
       matching, and so on. If [1msslclient [22mis not doing what you expect, try
       using this flag.

   [1mServer Identity Verification[0m
       If the server presents a valid SSL (X.509) certificate, a set of checks
       is applied to it to help ensure that [1msslclient [22mis communicating with
       the intended entity. Verification is successful and checking is
       terminated as soon as any test is successful. If no test succeeds, the
       program terminates immediately.

           [1mTip[0m
           You can use a command like the following one to display an X.509
           certificate to stdout in text form:

               % openssl x509 -noout -text < cert.crt

           Here, cert.crt is the certificate to display.

       The server certificate's subjectAltName extension fields have the
       format field-name:field-value. For each such field, tests are made in
       the following sequence:

        1. the entire field is matched against each of the regular expressions
           given on the command line.

        2. if the previous test failed and field-name is "DNS" (exact match),
           it is compared case insensitively to the server's name (as given on
           the command line).

        3. if the previous test failed and if the field-name is "IP Address"
           (exact match), it is compared to the server's name (exact match),
           which is assumed to be an IP address (as given on the command
           line).


       If the above procedure is unsuccessful and the server certificate's
       commonName attribute value is available, it is matched against each of
       the regular expressions given on the command line.

[1mEXAMPLES[0m
       The following command line attempts to connect to port 443 at
       example.com and prints to stdout the server's response to a request for
       the home page:

           % perl -e 'printf "GET / HTTP/1.0\n\n";' | sslclient example.com:443


[1mDIAGNOSTICS[0m
       When used with [1mDACS [22mlogging configured, messages are directed to a log
       file, otherwise error messages and verbose output are written to
       stderr. The program exits 0 if everything was fine, 1 if an error
       occurred.

[1mNOTES[0m
       A wrapper mode of operation might be useful.

       It would also be useful to have a mode where it listens for an SSL
       connection for input (rather than its standard input) and then relays
       data over that connection to a specified server, possibly but not
       necessarily via SSL. This mode might run on a firewall host to forward
       an approved incoming SSL connection (presumably authenticated by a
       client certificate, and possibly by a [1mDACS [22mruleset) to a service
       running on an interior host, for instance.

[1mSEE ALSO[0m
       [34m[1mhttp(1)[0m[1m[22m[2], [34m[1mopenssl(1)[0m[1m[22m[4], [34m[1ms_client(1)[0m[1m[22m[14], [34m[1mstunnel(1)[0m[1m[22m[15],
       [34m[1mcurl(1)[0m[1m[22m[16], [34m[1msslwrap(1)[0m[1m[22m[17], and others, and [34m[1mregex(3)[0m[1m[22m[18].

       A variety of reference material on SSL/TLS is available. Perhaps best
       is Network Security with OpenSSL by John Viega, Matt Messier, and
       Pravir Chandra, O'Reilly & Associates, Inc., 2002. Also useful are
       [34m[1mSSL/TLS Strong Encryption: An Introduction[0m[1m[22m[19], [34m[1mNetscape SSL 3.0[0m
       [1m[34mSpecification[0m[1m[22m[20], and [34m[1mRFC 2246[0m[1m[22m[21].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[22])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[23] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. http(1)
           http://dacs.dss.ca/man/http.1.html

        3. default SSL port for https (443)
           http://www.iana.org/assignments/port-numbers

        4. OpenSSL
           http://www.openssl.org

        5. [1mSSL_CTX_load_verify_locations()[0m
           http://www.openssl.org/docs/ssl/SSL_CTX_load_verify_locations.html

        6. mod_ssl's
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html

        7. SSLCACertificateFile
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatefile

        8. SSLCACertificatePath
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatepath

        9. [1mSSL_CTX_use_certificate_chain_file()[0m
           http://www.openssl.org/docs/ssl/SSL_CTX_use_certificate.html

       10. SSLCACertificateChainFile
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslcacertificatechainfile

       11. [1mSSL_CTX_set_cipher_list()[0m
           http://www.openssl.org/docs/ssl/SSL_CTX_set_cipher_list.html

       12. SSLCipherSuite
           http://httpd.apache.org/docs-2.2/mod/mod_ssl.html#sslciphersuite

       13. below
           http://dacs.dss.ca/man/#verificaton

       14. s_client(1)
           http://www.openssl.org/docs/apps/s_client.html

       15. stunnel(1)
           http://www.stunnel.org

       16. curl(1)
           http://directory.fsf.org/project/curl

       17. sslwrap(1)
           http://www.rickk.com/sslwrap

       18. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       19. SSL/TLS Strong Encryption: An Introduction
           http://httpd.apache.org/docs-2.2/ssl/ssl_intro.html

       20. Netscape SSL 3.0 Specification
           http://web.archive.org/web/20070717014933rn_1/wp.netscape.com/eng/ssl3//

       21. RFC 2246
           http://www.rfc-editor.org/rfc/rfc2246.txt

       22. www.dss.ca
           http://www.dss.ca

       23. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                      SSLCLIENT(1)
