// vs_size_box.h                       -*-c++-*-
//
// A container to ensure that its child has a particular minimum size
// (at least).
//
// Copyright 2004 Daniel Burrows

#ifndef VS_SIZE_BOX_H
#define VS_SIZE_BOX_H

#include "vs_bin.h"

/** A vs_size_box ensures that the minimum size of its child is a given size
 *  or larger.
 */
class vs_size_box:public vs_bin
{
  size min_size;

  /** Internal: actually allocates the child's size. */
  void layout_me();
public:
  /** Create a vs_size_box.
   *
   *  \param s the minimum size of this box
   *  \param w the widget initially contained in this box (\b NULL to
   *           create an initially empty box)
   */
  vs_size_box(size s, vscreen_widget *w=NULL);

  /** Returns the smallest size which is greater than both the minimum
   *  size passed to the constructor and the size request of the child.
   */
  size size_request();
};

#endif
