// vs_button.h      -*-c++-*-
//
//  A button is just a widget which accepts keyboard focus and can be
// "pressed".  I'm going to make a stab at sharing code between
// normal buttons, radio buttons, and checkbuttons..this may not be
// worth it..

#ifndef VS_BUTTON_H
#define VS_BUTTON_H

#include "vscreen_widget.h"

#include <string>

class vs_button:public vscreen_widget
{
  std::string label;

  void accept_focus();
  void lose_focus();

protected:
  bool handle_char(chtype ch);
public:
  vs_button(std::string _label);

  void paint();

  bool get_cursorvisible();
  point get_cursorloc();
  bool focus_me();
  size size_request();
  void dispatch_mouse(short id, int x, int y, int z, mmask_t bmask);

  std::string get_label() {return label;}
  void set_label(std::string _label) {label=_label;}

  // Signals:

  // The button has been "pressed" (activated)
  SigC::Signal0<void> pressed;
};

#endif
