/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PanelBuilder
extends AbstractFormBuilder {
    private ComponentFactory componentFactory;

    public PanelBuilder(JPanel panel, FormLayout layout) {
        super(panel, layout);
    }

    public PanelBuilder(FormLayout layout) {
        this(new JPanel(), layout);
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setDefaultDialogBorder() {
        this.setBorder(Borders.DIALOG_BORDER);
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints constraints) {
        JLabel label = this.getComponentFactory().createLabel(textWithMnemonic);
        this.add((Component)label, constraints);
        return label;
    }

    public final JLabel addLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addLabel(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JLabel addLabel(String textWithMnemonic) {
        return this.addLabel(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel add(JLabel label, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        this.add((Component)label, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        JLabel label = this.addLabel(textWithMnemonic, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final JLabel addTitle(String text, CellConstraints constraints) {
        JLabel titleLabel = this.getComponentFactory().createTitle(text);
        this.add((Component)titleLabel, constraints);
        return titleLabel;
    }

    public final JLabel addTitle(String text, String encodedConstraints) {
        return this.addTitle(text, new CellConstraints(encodedConstraints));
    }

    public final JLabel addTitle(String text) {
        return this.addTitle(text, this.cellConstraints());
    }

    public final JComponent addSeparator(String text, CellConstraints constraints) {
        int titleAlignment = this.isLeftToRight() ? 2 : 4;
        JComponent titledSeparator = this.getComponentFactory().createSeparator(text, titleAlignment);
        this.add((Component)titledSeparator, constraints);
        return titledSeparator;
    }

    public final JComponent addSeparator(String text, String encodedConstraints) {
        return this.addSeparator(text, new CellConstraints(encodedConstraints));
    }

    public final JComponent addSeparator(String text, int columnSpan) {
        return this.addSeparator(text, this.createLeftAdjustedConstraints(columnSpan));
    }

    public final JComponent addSeparator(String text) {
        return this.addSeparator(text, this.getLayout().getColumnCount());
    }

    protected final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory newFactory) {
        this.componentFactory = newFactory;
    }
}

