
/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IGuestMultiTouchEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when guest touch screen event happens.

Interface ID: <code>{1F99D9DC-C144-4C28-9F88-E6F488DB5441}</code>
*/
public class IGuestMultiTouchEvent extends IEvent
{

    public IGuestMultiTouchEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Number of contacts in the event.
@return Integer
*/
    public Integer getContactCount()
    {
        try
        {
            Integer retVal = port.iGuestMultiTouchEventGetContactCount(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
X positions.
@return List&lt;Short&gt;
*/
    public List<Short> getXPositions()
    {
        try
        {
            List<Short> retVal = port.iGuestMultiTouchEventGetXPositions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Y positions.
@return List&lt;Short&gt;
*/
    public List<Short> getYPositions()
    {
        try
        {
            List<Short> retVal = port.iGuestMultiTouchEventGetYPositions(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Contact identifiers.
@return List&lt;Integer&gt;
*/
    public List<Integer> getContactIds()
    {
        try
        {
            List<Integer> retVal = port.iGuestMultiTouchEventGetContactIds(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Contact state.
Bit 0: in contact.
Bit 1: in range.
@return List&lt;Integer&gt;
*/
    public List<Integer> getContactFlags()
    {
        try
        {
            List<Integer> retVal = port.iGuestMultiTouchEventGetContactFlags(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Distinguishes between touchscreen and touchpad events.
@return Boolean
*/
    public Boolean getIsTouchScreen()
    {
        try
        {
            Boolean retVal = port.iGuestMultiTouchEventGetIsTouchScreen(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Timestamp of the event in milliseconds. Only relative time between events is important.
@return Long
*/
    public Long getScanTime()
    {
        try
        {
            Long retVal = port.iGuestMultiTouchEventGetScanTime(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestMultiTouchEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestMultiTouchEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
