/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.SQLException;
import java.time.Duration;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.datasources.AbstractConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

final class CPDSConnectionFactory
extends AbstractConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private ObjectPool<PooledConnectionAndInfo> pool;
    private UserPassKey userPassKey;

    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, Duration duration, boolean bl, String string2, char[] cArray) {
        super(connectionPoolDataSource, string, duration, bl);
        this.userPassKey = new UserPassKey(string2, cArray);
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String string) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this.userPassKey.getUserName())) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error closing connection pool", exception);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.doDestroyObject(pooledObject.getObject());
    }

    private void doDestroyObject(PooledConnectionAndInfo pooledConnectionAndInfo) throws SQLException {
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    char[] getPasswordCharArray() {
        return this.userPassKey.getPasswordCharArray();
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = (PooledConnectionAndInfo)this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.close();
            this.pool.invalidateObject(pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            throw new SQLException("Error invalidating connection", exception);
        }
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() throws SQLException {
        PooledConnection pooledConnection = null;
        pooledConnection = this.userPassKey.getUserName() == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userPassKey.getUserName(), this.userPassKey.getPassword());
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this.userPassKey);
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return new DefaultPooledObject<PooledConnectionAndInfo>(pooledConnectionAndInfo);
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
    }

    @Override
    public synchronized void setPassword(char[] cArray) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), cArray);
    }

    @Override
    public synchronized void setPassword(String string) {
        this.userPassKey = new UserPassKey(this.userPassKey.getUserName(), string);
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> objectPool) {
        this.pool = objectPool;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[cpds=");
        stringBuilder.append(this.cpds);
        stringBuilder.append(", validationQuery=");
        stringBuilder.append(this.validationQuery);
        stringBuilder.append(", validationQueryTimeoutDuration=");
        stringBuilder.append(this.validationQueryTimeoutDuration);
        stringBuilder.append(", rollbackAfterValidation=");
        stringBuilder.append(this.rollbackAfterValidation);
        stringBuilder.append(", pool=");
        stringBuilder.append(this.pool);
        stringBuilder.append(", maxConnDuration=");
        stringBuilder.append(this.maxConnDuration);
        stringBuilder.append(", validatingSet=");
        stringBuilder.append(this.validatingSet);
        stringBuilder.append(", pcMap=");
        stringBuilder.append(this.pcMap);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

