/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.Group;
import org.apache.tomcat.util.net.openssl.ciphers.SignatureScheme;
import org.apache.tomcat.util.res.StringManager;

public class TLSClientHelloExtractor {
    private static final Log log = LogFactory.getLog(TLSClientHelloExtractor.class);
    private static final StringManager sm = StringManager.getManager(TLSClientHelloExtractor.class);
    private final ExtractorResult result;
    private final List<Cipher> clientRequestedCiphers;
    private final List<String> clientRequestedCipherNames;
    private final String sniValue;
    private final List<String> clientRequestedApplicationProtocols;
    private final List<String> clientRequestedProtocols;
    private final List<Group> clientSupportedGroups;
    private final List<SignatureScheme> clientSignatureSchemes;
    private static final int TLS_RECORD_HEADER_LEN = 5;
    private static final int TLS_EXTENSION_SERVER_NAME = 0;
    private static final int TLS_EXTENSION_SUPPORTED_GROUPS = 10;
    private static final int TLS_EXTENSION_SIGNATURE_ALGORITHMS = 13;
    private static final int TLS_EXTENSION_ALPN = 16;
    private static final int TLS_EXTENSION_SUPPORTED_VERSION = 43;
    public static byte[] USE_TLS_RESPONSE = "HTTP/1.1 400 \r\nContent-Type: text/plain;charset=UTF-8\r\nConnection: close\r\n\r\nBad Request\r\nThis combination of host and port requires TLS.\r\n".getBytes(StandardCharsets.UTF_8);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TLSClientHelloExtractor(ByteBuffer byteBuffer) throws IOException {
        String string;
        ArrayList<SignatureScheme> arrayList;
        ArrayList<Group> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        ArrayList<String> arrayList5;
        ArrayList<Cipher> arrayList6;
        ExtractorResult extractorResult;
        int n;
        int n2;
        block32: {
            block31: {
                n2 = byteBuffer.position();
                n = byteBuffer.limit();
                extractorResult = ExtractorResult.NOT_PRESENT;
                arrayList6 = new ArrayList<Cipher>();
                arrayList5 = new ArrayList<String>();
                arrayList4 = new ArrayList<String>();
                arrayList3 = new ArrayList<String>();
                arrayList2 = new ArrayList<Group>();
                arrayList = new ArrayList<SignatureScheme>();
                string = null;
                try {
                    char c;
                    int n3;
                    byteBuffer.flip();
                    if (!TLSClientHelloExtractor.isAvailable(byteBuffer, 5)) {
                        extractorResult = TLSClientHelloExtractor.handleIncompleteRead(byteBuffer);
                        return;
                    }
                    if (!TLSClientHelloExtractor.isTLSHandshake(byteBuffer)) {
                        if (!TLSClientHelloExtractor.isHttp(byteBuffer)) return;
                        extractorResult = ExtractorResult.NON_SECURE;
                        return;
                    }
                    if (!TLSClientHelloExtractor.isAllRecordAvailable(byteBuffer)) {
                        extractorResult = TLSClientHelloExtractor.handleIncompleteRead(byteBuffer);
                        return;
                    }
                    if (!TLSClientHelloExtractor.isClientHello(byteBuffer)) {
                        return;
                    }
                    if (!TLSClientHelloExtractor.isAllClientHelloAvailable(byteBuffer)) {
                        log.warn((Object)sm.getString("sniExtractor.clientHelloTooBig"));
                        return;
                    }
                    String string2 = TLSClientHelloExtractor.readProtocol(byteBuffer);
                    TLSClientHelloExtractor.skipBytes(byteBuffer, 32);
                    TLSClientHelloExtractor.skipBytes(byteBuffer, byteBuffer.get() & 0xFF);
                    int n4 = byteBuffer.getChar() / 2;
                    for (n3 = 0; n3 < n4; ++n3) {
                        c = byteBuffer.getChar();
                        Cipher cipher = Cipher.valueOf(c);
                        if (cipher == null) {
                            arrayList5.add("Unknown(0x" + HexUtils.toHexString((char)c) + ")");
                            continue;
                        }
                        arrayList6.add(cipher);
                        arrayList5.add(cipher.name());
                    }
                    TLSClientHelloExtractor.skipBytes(byteBuffer, byteBuffer.get() & 0xFF);
                    if (!byteBuffer.hasRemaining()) {
                        this.result = extractorResult;
                        this.clientRequestedCiphers = arrayList6;
                        this.clientRequestedCipherNames = arrayList5;
                        this.clientRequestedApplicationProtocols = arrayList4;
                        this.sniValue = string;
                        this.clientRequestedProtocols = arrayList3;
                        this.clientSupportedGroups = arrayList2;
                        this.clientSignatureSchemes = arrayList;
                        break block31;
                    }
                    TLSClientHelloExtractor.skipBytes(byteBuffer, 2);
                    block19: while (byteBuffer.hasRemaining() && (string == null || arrayList4.isEmpty() || arrayList3.isEmpty())) {
                        n3 = byteBuffer.getChar();
                        c = byteBuffer.getChar();
                        switch (n3) {
                            case 0: {
                                string = TLSClientHelloExtractor.readSniExtension(byteBuffer);
                                continue block19;
                            }
                            case 10: {
                                TLSClientHelloExtractor.readSupportedGroups(byteBuffer, arrayList2);
                                continue block19;
                            }
                            case 13: {
                                TLSClientHelloExtractor.readSignatureSchemes(byteBuffer, arrayList);
                                continue block19;
                            }
                            case 16: {
                                TLSClientHelloExtractor.readAlpnExtension(byteBuffer, arrayList4);
                                continue block19;
                            }
                            case 43: {
                                TLSClientHelloExtractor.readSupportedVersions(byteBuffer, arrayList3);
                                continue block19;
                            }
                        }
                        TLSClientHelloExtractor.skipBytes(byteBuffer, c);
                    }
                    if (arrayList3.isEmpty()) {
                        arrayList3.add(string2);
                    }
                    this.result = extractorResult = ExtractorResult.COMPLETE;
                    break block32;
                }
                catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
                    throw new IOException(sm.getString("sniExtractor.clientHelloInvalid"), runtimeException);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("TLS Client Hello: " + String.valueOf(arrayList6) + " Names " + String.valueOf(arrayList5) + " Protocols " + String.valueOf(arrayList4) + " sniValue " + string + " clientRequestedProtocols " + String.valueOf(arrayList3) + " clientSupportedGroups " + String.valueOf(arrayList2) + " clientSignatureSchemes " + String.valueOf(arrayList)));
            }
            byteBuffer.limit(n);
            byteBuffer.position(n2);
            return;
        }
        this.clientRequestedCiphers = arrayList6;
        this.clientRequestedCipherNames = arrayList5;
        this.clientRequestedApplicationProtocols = arrayList4;
        this.sniValue = string;
        this.clientRequestedProtocols = arrayList3;
        this.clientSupportedGroups = arrayList2;
        this.clientSignatureSchemes = arrayList;
        if (log.isTraceEnabled()) {
            log.trace((Object)("TLS Client Hello: " + String.valueOf(arrayList6) + " Names " + String.valueOf(arrayList5) + " Protocols " + String.valueOf(arrayList4) + " sniValue " + string + " clientRequestedProtocols " + String.valueOf(arrayList3) + " clientSupportedGroups " + String.valueOf(arrayList2) + " clientSignatureSchemes " + String.valueOf(arrayList)));
        }
        byteBuffer.limit(n);
        byteBuffer.position(n2);
        return;
        finally {
            this.result = extractorResult;
            this.clientRequestedCiphers = arrayList6;
            this.clientRequestedCipherNames = arrayList5;
            this.clientRequestedApplicationProtocols = arrayList4;
            this.sniValue = string;
            this.clientRequestedProtocols = arrayList3;
            this.clientSupportedGroups = arrayList2;
            this.clientSignatureSchemes = arrayList;
            if (log.isTraceEnabled()) {
                log.trace((Object)("TLS Client Hello: " + String.valueOf(arrayList6) + " Names " + String.valueOf(arrayList5) + " Protocols " + String.valueOf(arrayList4) + " sniValue " + string + " clientRequestedProtocols " + String.valueOf(arrayList3) + " clientSupportedGroups " + String.valueOf(arrayList2) + " clientSignatureSchemes " + String.valueOf(arrayList)));
            }
            byteBuffer.limit(n);
            byteBuffer.position(n2);
        }
    }

    public ExtractorResult getResult() {
        return this.result;
    }

    public String getSNIValue() {
        if (this.result == ExtractorResult.COMPLETE) {
            return this.sniValue;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<Cipher> getClientRequestedCiphers() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedCiphers;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedCipherNames() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedCipherNames;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedApplicationProtocols() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedApplicationProtocols;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedProtocols() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedProtocols;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<Group> getClientSupportedGroups() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientSupportedGroups;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<SignatureScheme> getClientSignatureSchemes() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientSignatureSchemes;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    private static ExtractorResult handleIncompleteRead(ByteBuffer byteBuffer) {
        if (byteBuffer.limit() == byteBuffer.capacity()) {
            return ExtractorResult.UNDERFLOW;
        }
        return ExtractorResult.NEED_READ;
    }

    private static boolean isAvailable(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.remaining() < n) {
            byteBuffer.position(byteBuffer.limit());
            return false;
        }
        return true;
    }

    private static boolean isTLSHandshake(ByteBuffer byteBuffer) {
        if (byteBuffer.get() != 22) {
            return false;
        }
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        return by >= 3 && (by != 3 || by2 != 0);
    }

    private static boolean isHttp(ByteBuffer byteBuffer) {
        byte by;
        byteBuffer.position(0);
        do {
            if (byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) == 13 || by == 10);
        do {
            if (HttpParser.isToken(by) && byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) != 32 && by != 9);
        while (by == 32 || by == 9) {
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        while (by != 32 && by != 9) {
            if (HttpParser.isNotRequestTarget(by) || !byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        while (by == 32 || by == 9) {
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        do {
            if (HttpParser.isHttpProtocol(by) && byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) != 13 && by != 10);
        return true;
    }

    private static boolean isAllRecordAvailable(ByteBuffer byteBuffer) {
        char c = byteBuffer.getChar();
        return TLSClientHelloExtractor.isAvailable(byteBuffer, c);
    }

    private static boolean isClientHello(ByteBuffer byteBuffer) {
        return byteBuffer.get() == 1;
    }

    private static boolean isAllClientHelloAvailable(ByteBuffer byteBuffer) {
        int n = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
        return TLSClientHelloExtractor.isAvailable(byteBuffer, n);
    }

    private static void skipBytes(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(byteBuffer.position() + n);
    }

    private static String readProtocol(ByteBuffer byteBuffer) {
        char c = byteBuffer.getChar();
        switch (c) {
            case '\u0300': {
                return "SSLv3";
            }
            case '\u0301': {
                return "TLSv1.0";
            }
            case '\u0302': {
                return "TLSv1.1";
            }
            case '\u0303': {
                return "TLSv1.2";
            }
            case '\u0304': {
                return "TLSv1.3";
            }
        }
        return "Unknown(0x" + HexUtils.toHexString((char)c) + ")";
    }

    private static String readSniExtension(ByteBuffer byteBuffer) {
        TLSClientHelloExtractor.skipBytes(byteBuffer, 3);
        char c = byteBuffer.getChar();
        byte[] byArray = new byte[c];
        byteBuffer.get(byArray);
        return new String(byArray, StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH);
    }

    private static void readAlpnExtension(ByteBuffer byteBuffer, List<String> list) {
        char c = byteBuffer.getChar();
        byte[] byArray = new byte[255];
        while (c > '\u0000') {
            int n = byteBuffer.get() & 0xFF;
            byteBuffer.get(byArray, 0, n);
            list.add(new String(byArray, 0, n, StandardCharsets.UTF_8));
            c = (char)(c - '\u0001');
            c = (char)(c - (char)n);
        }
    }

    private static void readSupportedVersions(ByteBuffer byteBuffer, List<String> list) {
        int n = (byteBuffer.get() & 0xFF) / 2;
        for (int i = 0; i < n; ++i) {
            list.add(TLSClientHelloExtractor.readProtocol(byteBuffer));
        }
    }

    private static void readSupportedGroups(ByteBuffer byteBuffer, List<Group> list) {
        int n = byteBuffer.getChar() / 2;
        for (int i = 0; i < n; ++i) {
            char c = byteBuffer.getChar();
            Group group = Group.valueOf(c);
            if (group == null) continue;
            list.add(group);
        }
    }

    private static void readSignatureSchemes(ByteBuffer byteBuffer, List<SignatureScheme> list) {
        int n = byteBuffer.getChar() / 2;
        for (int i = 0; i < n; ++i) {
            char c = byteBuffer.getChar();
            SignatureScheme signatureScheme = SignatureScheme.valueOf(c);
            if (signatureScheme == null) continue;
            list.add(signatureScheme);
        }
    }

    public static enum ExtractorResult {
        COMPLETE,
        NOT_PRESENT,
        UNDERFLOW,
        NEED_READ,
        NON_SECURE;

    }
}

