/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class ShinyDiffuseShader
implements Shader {
    private Color diff = Color.GRAY;
    private float refl = 0.5f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.diff = parameterList.getColor("diffuse", this.diff);
        this.refl = parameterList.getFloat("shiny", this.refl);
        return true;
    }

    protected float getShininess() {
        return this.refl;
    }

    public Color getDiffuse(ShadingState shadingState) {
        return this.diff;
    }

    public Color getRadiance(ShadingState shadingState) {
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Color color = this.getDiffuse(shadingState);
        Color color2 = shadingState.diffuse(color);
        if (!shadingState.includeSpecular()) {
            return color2;
        }
        float f = shadingState.getCosND();
        float f2 = 2.0f * f;
        Vector3 vector3 = new Vector3();
        vector3.x = f2 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
        vector3.y = f2 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
        vector3.z = f2 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
        Ray ray = new Ray(shadingState.getPoint(), vector3);
        f = 1.0f - f;
        float f3 = f * f;
        float f4 = f3 * f3 * f;
        Color color3 = Color.white();
        Color color4 = color.copy().mul(this.refl);
        color3.sub(color4);
        color3.mul(f4);
        color3.add(color4);
        return color2.add(color3.mul(shadingState.traceReflection(ray, 0)));
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        shadingState.faceforward();
        Color color2 = this.getDiffuse(shadingState);
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        float f = color2.getAverage();
        float f2 = f * this.refl;
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            color.mul(color2).mul(1.0f / f);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d2 = Math.PI * 2 * d / (double)f;
            double d3 = shadingState.getRandom(0, 1, 1);
            float f3 = (float)Math.sqrt(d3);
            float f4 = (float)Math.sqrt(1.0 - d3);
            Vector3 vector3 = new Vector3((float)Math.cos(d2) * f3, (float)Math.sin(d2) * f3, f4);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        } else if (d < (double)(f + f2)) {
            float f5 = -Vector3.dot(shadingState.getNormal(), shadingState.getRay().getDirection());
            color.mul(color2).mul(1.0f / f);
            float f6 = 2.0f * f5;
            Vector3 vector3 = new Vector3();
            vector3.x = f6 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
            vector3.y = f6 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
            vector3.z = f6 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
            shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector3), color);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getOpacity(ShadingState shadingState) {
        return null;
    }
}

