\name{LabelVotingImageFilter}
\alias{LabelVotingImageFilter}
\title{LabelVotingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter performs pixelwise voting among an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).
LabelVotingImageFilter}
\details{
Label voting is a simple method of classifier combination applied to image
segmentation. Typically, the accuracy of the combined segmentation
exceeds the accuracy of any of the input segmentations. Voting is
therefore commonly used as a way of boosting segmentation performance.
The use of label voting for combination of multiple segmentations is
described in
T. Rohlfing and C. R. Maurer, Jr., "Multi-classifier framework for
atlas-based image segmentation," Pattern Recognition Letters, 2005.
INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.
OUTPUTS
The voting filter produces a single output volume. Each output pixel
contains the label that occurred most often among the labels assigned
to this pixel in all the input volumes, that is, the label that
received the maximum number of "votes" from the input pixels.. If
the maximum number of votes is not unique, i.e., if more than one
label have a maximum number of votes, an "undecided" label is
assigned to that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.
PARAMETERS
The label used for "undecided" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.
Torsten Rohlfing, SRI International, Neuroscience Program
See:
LabelVoting for the procedural interface
LabelVotingImageFilter}
%C++ includes: sitkLabelVotingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4):}{}
\item{Image Execute(const Image &image1, const Image &image2, const Image &image3, const Image &image4, const Image &image5):}{}
\item{Image Execute(const std::vector< Image > &images):}{
Execute the filter on the input images
}
\item{uint64_t GetLabelForUndecidedPixels() const:}{
Get label value used for undecided pixels. After updating the filter,
this function returns the actual label value used for undecided pixels
in the current output. Note that this value is overwritten when
SetLabelForUndecidedPixels is called and the new value only becomes
effective upon the next filter update.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ LabelVotingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels):}{
Set label value for undecided pixels.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelVotingImageFilter():}{
Destructor
}
}
}
