/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LayerConstraintPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer constraint postprocessing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (!layers.isEmpty()) {
            Layer firstLayer = layers.get(0);
            Layer lastLayer = layers.get(layers.size() - 1);
            Layer firstLabelLayer = new Layer(layeredGraph);
            Layer lastLabelLayer = new Layer(layeredGraph);
            this.moveFirstAndLastNodes(layeredGraph, firstLayer, lastLayer, firstLabelLayer, lastLabelLayer);
            if (!firstLabelLayer.getNodes().isEmpty()) {
                layers.add(0, firstLabelLayer);
            }
            if (!lastLabelLayer.getNodes().isEmpty()) {
                layers.add(lastLabelLayer);
            }
        }
        if (layeredGraph.hasProperty(InternalProperties.HIDDEN_NODES)) {
            Layer firstSeparateLayer = new Layer(layeredGraph);
            Layer lastSeparateLayer = new Layer(layeredGraph);
            this.restoreHiddenNodes(layeredGraph, firstSeparateLayer, lastSeparateLayer);
            if (!firstSeparateLayer.getNodes().isEmpty()) {
                layers.add(0, firstSeparateLayer);
            }
            if (!lastSeparateLayer.getNodes().isEmpty()) {
                layers.add(lastSeparateLayer);
            }
        }
        monitor.done();
    }

    private void moveFirstAndLastNodes(LGraph layeredGraph, Layer firstLayer, Layer lastLayer, Layer firstLabelLayer, Layer lastLabelLayer) {
        for (Layer layer : layeredGraph) {
            LNode[] nodes;
            LNode[] lNodeArray = nodes = LGraphUtil.toNodeArray(layer.getNodes());
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                LNode node = lNodeArray[n2];
                switch (node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
                    case FIRST: {
                        this.throwUpUnlessNoIncomingEdges(node);
                        node.setLayer(firstLayer);
                        this.moveLabelsToLabelLayer(node, true, firstLabelLayer);
                        break;
                    }
                    case LAST: {
                        this.throwUpUnlessNoOutgoingEdges(node);
                        node.setLayer(lastLayer);
                        this.moveLabelsToLabelLayer(node, false, lastLabelLayer);
                    }
                }
                ++n2;
            }
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            if (!layerIter.next().getNodes().isEmpty()) continue;
            layerIter.remove();
        }
    }

    private void moveLabelsToLabelLayer(LNode node, boolean incoming, Layer labelLayer) {
        for (LEdge edge : incoming ? node.getIncomingEdges() : node.getOutgoingEdges()) {
            LNode possibleLableDummy;
            LNode lNode = possibleLableDummy = incoming ? edge.getSource().getNode() : edge.getTarget().getNode();
            if (possibleLableDummy.getType() != LNode.NodeType.LABEL) continue;
            possibleLableDummy.setLayer(labelLayer);
        }
    }

    private void restoreHiddenNodes(LGraph layeredGraph, Layer firstSeparateLayer, Layer lastSeparateLayer) {
        for (LNode hiddenNode : layeredGraph.getProperty(InternalProperties.HIDDEN_NODES)) {
            switch (hiddenNode.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
                case FIRST_SEPARATE: {
                    hiddenNode.setLayer(firstSeparateLayer);
                    break;
                }
                case LAST_SEPARATE: {
                    hiddenNode.setLayer(lastSeparateLayer);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            for (LEdge hiddenEdge : hiddenNode.getConnectedEdges()) {
                if (hiddenEdge.getSource() != null && hiddenEdge.getTarget() != null) continue;
                boolean isOutgoing = hiddenEdge.getTarget() == null;
                LPort originalOppositePort = hiddenEdge.getProperty(InternalProperties.ORIGINAL_OPPOSITE_PORT);
                if (isOutgoing) {
                    hiddenEdge.setTarget(originalOppositePort);
                    continue;
                }
                hiddenEdge.setSource(originalOppositePort);
            }
        }
    }

    private void throwUpUnlessNoIncomingEdges(LNode node) {
        for (LEdge incoming : node.getIncomingEdges()) {
            if (incoming.getSource().getNode().getType() == LNode.NodeType.LABEL) continue;
            throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to FIRST, but has at least one incoming edge that  does not come from a FIRST_SEPARATE node. That must not happen.");
        }
    }

    private void throwUpUnlessNoOutgoingEdges(LNode node) {
        for (LEdge outgoing : node.getOutgoingEdges()) {
            if (outgoing.getTarget().getNode().getType() == LNode.NodeType.LABEL) continue;
            throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to LAST, but has at least one outgoing edge that  does not go to a LAST_SEPARATE node. That must not happen.");
        }
    }
}

