/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.DirectionCongruency;
import org.eclipse.elk.alg.layered.options.EdgeLabelSideSelection;
import org.eclipse.elk.alg.layered.options.InLayerConstraint;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class GraphTransformer
implements ILayoutProcessor<LGraph> {
    private final Mode mode;

    public GraphTransformer(Mode themode) {
        this.mode = themode;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Graph transformation (" + String.valueOf((Object)this.mode) + ")", 1.0f);
        ArrayList<LNode> nodes = Lists.newArrayList(layeredGraph.getLayerlessNodes());
        for (Layer layer : layeredGraph.getLayers()) {
            nodes.addAll(layer.getNodes());
        }
        DirectionCongruency congruency = layeredGraph.getProperty(LayeredOptions.DIRECTION_CONGRUENCY);
        if (congruency == DirectionCongruency.READING_DIRECTION) {
            switch (layeredGraph.getProperty(LayeredOptions.DIRECTION)) {
                case LEFT: {
                    this.mirrorAllX(layeredGraph, nodes);
                    break;
                }
                case DOWN: {
                    this.transposeAll(layeredGraph, nodes);
                    break;
                }
                case UP: {
                    if (this.mode == Mode.TO_INTERNAL_LTR) {
                        this.transposeAll(layeredGraph, nodes);
                        this.mirrorAllY(layeredGraph, nodes);
                        break;
                    }
                    this.mirrorAllY(layeredGraph, nodes);
                    this.transposeAll(layeredGraph, nodes);
                }
            }
        } else if (this.mode == Mode.TO_INTERNAL_LTR) {
            switch (layeredGraph.getProperty(LayeredOptions.DIRECTION)) {
                case LEFT: {
                    this.mirrorAllX(layeredGraph, nodes);
                    this.mirrorAllY(layeredGraph, nodes);
                    break;
                }
                case DOWN: {
                    this.rotate90Clockwise(layeredGraph, nodes);
                    break;
                }
                case UP: {
                    this.rotate90CounterClockwise(layeredGraph, nodes);
                }
            }
        } else {
            switch (layeredGraph.getProperty(LayeredOptions.DIRECTION)) {
                case LEFT: {
                    this.mirrorAllX(layeredGraph, nodes);
                    this.mirrorAllY(layeredGraph, nodes);
                    break;
                }
                case DOWN: {
                    this.rotate90CounterClockwise(layeredGraph, nodes);
                    break;
                }
                case UP: {
                    this.rotate90Clockwise(layeredGraph, nodes);
                }
            }
        }
        monitor.done();
    }

    private void rotate90Clockwise(LGraph layeredGraph, List<LNode> nodes) {
        this.transposeAll(layeredGraph, nodes);
        this.mirrorAllX(layeredGraph, nodes);
    }

    private void rotate90CounterClockwise(LGraph layeredGraph, List<LNode> nodes) {
        this.mirrorAllX(layeredGraph, nodes);
        this.transposeAll(layeredGraph, nodes);
    }

    private void mirrorAllX(LGraph layeredGraph, List<LNode> nodes) {
        this.mirrorX(nodes, layeredGraph);
        this.mirrorX(layeredGraph.getPadding());
        this.mirrorX(layeredGraph.getProperty(LayeredOptions.NODE_LABELS_PADDING));
    }

    private void mirrorAllY(LGraph layeredGraph, List<LNode> nodes) {
        this.mirrorY(nodes, layeredGraph);
        this.mirrorY(layeredGraph.getPadding());
        this.mirrorY(layeredGraph.getProperty(LayeredOptions.NODE_LABELS_PADDING));
    }

    private void transposeAll(LGraph layeredGraph, List<LNode> nodes) {
        this.transpose(nodes);
        this.transposeEdgeLabelPlacement(layeredGraph);
        this.transpose(layeredGraph.getOffset());
        this.transpose(layeredGraph.getSize());
        this.transpose(layeredGraph.getPadding());
        this.transpose(layeredGraph.getProperty(LayeredOptions.NODE_LABELS_PADDING));
    }

    private void mirrorX(List<LNode> nodes, LGraph graph) {
        double offset = 0.0;
        if (graph.getSize().x == 0.0) {
            for (LNode node : nodes) {
                offset = Math.max(offset, node.getPosition().x + node.getSize().x + node.getMargin().right);
            }
        } else {
            offset = graph.getSize().x - graph.getOffset().x;
        }
        offset -= graph.getOffset().x;
        for (LNode node : nodes) {
            this.mirrorX(node.getPosition(), offset - node.getSize().x);
            this.mirrorX(node.getPadding());
            this.mirrorNodeLabelPlacementX(node);
            if (node.getAllProperties().containsKey(LayeredOptions.POSITION)) {
                this.mirrorX(node.getProperty(LayeredOptions.POSITION), offset - node.getSize().x);
            }
            switch (node.getProperty(LayeredOptions.ALIGNMENT)) {
                case LEFT: {
                    node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.RIGHT);
                    break;
                }
                case RIGHT: {
                    node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.LEFT);
                }
            }
            KVector nodeSize = node.getSize();
            for (LPort port : node.getPorts()) {
                this.mirrorX(port.getPosition(), nodeSize.x - port.getSize().x);
                this.mirrorX(port.getAnchor(), port.getSize().x);
                this.mirrorPortSideX(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.mirrorX(bendPoint, offset);
                    }
                    KVectorChain junctionPoints = edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.mirrorX(jp, offset);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.mirrorX(label.getPosition(), offset - label.getSize().x);
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.mirrorX(label.getPosition(), port.getSize().x - label.getSize().x);
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.mirrorExternalPortSideX(node);
                this.mirrorLayerConstraintX(node);
            }
            for (LLabel label : node.getLabels()) {
                this.mirrorNodeLabelPlacementX(label);
                this.mirrorX(label.getPosition(), nodeSize.x - label.getSize().x);
            }
        }
    }

    private void mirrorX(KVector v, double offset) {
        v.x = offset - v.x;
    }

    private void mirrorX(Spacing spacing) {
        double oldRight;
        double oldLeft = spacing.left;
        spacing.left = oldRight = spacing.right;
        spacing.right = oldLeft;
    }

    private void mirrorNodeLabelPlacementX(LShape shape) {
        if (!shape.hasProperty(LayeredOptions.NODE_LABELS_PLACEMENT)) {
            return;
        }
        Set oldPlacement = shape.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
        if (oldPlacement.contains((Object)NodeLabelPlacement.H_LEFT)) {
            oldPlacement.remove((Object)NodeLabelPlacement.H_LEFT);
            oldPlacement.add(NodeLabelPlacement.H_RIGHT);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.H_RIGHT)) {
            oldPlacement.remove((Object)NodeLabelPlacement.H_RIGHT);
            oldPlacement.add(NodeLabelPlacement.H_LEFT);
        }
    }

    private void mirrorPortSideX(LPort port) {
        port.setSide(this.getMirroredPortSideX(port.getSide()));
    }

    private void mirrorExternalPortSideX(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, (Object)this.getMirroredPortSideX(node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private PortSide getMirroredPortSideX(PortSide side) {
        switch (side) {
            case EAST: {
                return PortSide.WEST;
            }
            case WEST: {
                return PortSide.EAST;
            }
        }
        return side;
    }

    private void mirrorLayerConstraintX(LNode node) {
        switch (node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
            case FIRST: {
                node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.LAST);
                break;
            }
            case FIRST_SEPARATE: {
                node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
                break;
            }
            case LAST: {
                node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST);
                break;
            }
            case LAST_SEPARATE: {
                node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
            }
        }
    }

    private void mirrorY(List<LNode> nodes, LGraph graph) {
        double offset = 0.0;
        if (graph.getSize().y == 0.0) {
            for (LNode node : nodes) {
                offset = Math.max(offset, node.getPosition().y + node.getSize().y + node.getMargin().bottom);
            }
        } else {
            offset = graph.getSize().y - graph.getOffset().y;
        }
        offset -= graph.getOffset().y;
        for (LNode node : nodes) {
            this.mirrorY(node.getPosition(), offset - node.getSize().y);
            this.mirrorY(node.getPadding());
            this.mirrorNodeLabelPlacementY(node);
            if (node.getAllProperties().containsKey(LayeredOptions.POSITION)) {
                this.mirrorY(node.getProperty(LayeredOptions.POSITION), offset - node.getSize().y);
            }
            switch (node.getProperty(LayeredOptions.ALIGNMENT)) {
                case TOP: {
                    node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.BOTTOM);
                    break;
                }
                case BOTTOM: {
                    node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.TOP);
                }
            }
            KVector nodeSize = node.getSize();
            for (LPort port : node.getPorts()) {
                this.mirrorY(port.getPosition(), nodeSize.y - port.getSize().y);
                this.mirrorY(port.getAnchor(), port.getSize().y);
                this.mirrorPortSideY(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.mirrorY(bendPoint, offset);
                    }
                    KVectorChain junctionPoints = edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.mirrorY(jp, offset);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.mirrorY(label.getPosition(), offset - label.getSize().y);
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.mirrorY(label.getPosition(), port.getSize().y - label.getSize().y);
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.mirrorExternalPortSideY(node);
                this.mirrorInLayerConstraintY(node);
            }
            for (LLabel label : node.getLabels()) {
                this.mirrorNodeLabelPlacementY(label);
                this.mirrorY(label.getPosition(), nodeSize.y - label.getSize().y);
            }
        }
    }

    private void mirrorY(KVector v, double offset) {
        v.y = offset - v.y;
    }

    private void mirrorY(Spacing spacing) {
        double oldBottom;
        double oldTop = spacing.top;
        spacing.top = oldBottom = spacing.bottom;
        spacing.bottom = oldTop;
    }

    private void mirrorNodeLabelPlacementY(LShape shape) {
        if (!shape.hasProperty(LayeredOptions.NODE_LABELS_PLACEMENT)) {
            return;
        }
        Set oldPlacement = shape.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
        if (oldPlacement.contains((Object)NodeLabelPlacement.V_TOP)) {
            oldPlacement.remove((Object)NodeLabelPlacement.V_TOP);
            oldPlacement.add(NodeLabelPlacement.V_BOTTOM);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.V_BOTTOM)) {
            oldPlacement.remove((Object)NodeLabelPlacement.V_BOTTOM);
            oldPlacement.add(NodeLabelPlacement.V_TOP);
        }
    }

    private void mirrorPortSideY(LPort port) {
        port.setSide(this.getMirroredPortSideY(port.getSide()));
    }

    private void mirrorExternalPortSideY(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, (Object)this.getMirroredPortSideY(node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private PortSide getMirroredPortSideY(PortSide side) {
        switch (side) {
            case NORTH: {
                return PortSide.SOUTH;
            }
            case SOUTH: {
                return PortSide.NORTH;
            }
        }
        return side;
    }

    private void mirrorInLayerConstraintY(LNode node) {
        switch (node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT)) {
            case TOP: {
                node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
                break;
            }
            case BOTTOM: {
                node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
            }
        }
    }

    private void transpose(List<LNode> nodes) {
        for (LNode node : nodes) {
            this.transpose(node.getPosition());
            this.transpose(node.getSize());
            this.transpose(node.getPadding());
            this.transposeNodeLabelPlacement(node);
            this.transposeProperties(node);
            for (LPort port : node.getPorts()) {
                this.transpose(port.getPosition());
                this.transpose(port.getAnchor());
                this.transpose(port.getSize());
                this.transposePortSide(port);
                this.reverseIndex(port);
                for (LEdge edge : port.getOutgoingEdges()) {
                    for (KVector bendPoint : edge.getBendPoints()) {
                        this.transpose(bendPoint);
                    }
                    KVectorChain junctionPoints = edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        for (KVector jp : junctionPoints) {
                            this.transpose(jp);
                        }
                    }
                    for (LLabel label : edge.getLabels()) {
                        this.transpose(label.getPosition());
                        this.transpose(label.getSize());
                    }
                }
                for (LLabel label : port.getLabels()) {
                    this.transpose(label.getPosition());
                    this.transpose(label.getSize());
                }
            }
            if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                this.transposeExternalPortSide(node);
                this.transposeLayerConstraint(node);
            }
            for (LLabel label : node.getLabels()) {
                this.transposeNodeLabelPlacement(label);
                this.transpose(label.getSize());
                this.transpose(label.getPosition());
            }
        }
    }

    private void transpose(KVector v) {
        double temp = v.x;
        v.x = v.y;
        v.y = temp;
    }

    private void transpose(Spacing spacing) {
        double oldTop = spacing.top;
        double oldBottom = spacing.bottom;
        double oldLeft = spacing.left;
        double oldRight = spacing.right;
        spacing.top = oldLeft;
        spacing.bottom = oldRight;
        spacing.left = oldTop;
        spacing.right = oldBottom;
    }

    private void transposeNodeLabelPlacement(LShape shape) {
        if (!shape.hasProperty(LayeredOptions.NODE_LABELS_PLACEMENT)) {
            return;
        }
        Set oldPlacement = shape.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
        if (oldPlacement.isEmpty()) {
            return;
        }
        EnumSet<NodeLabelPlacement> newPlacement = EnumSet.noneOf(NodeLabelPlacement.class);
        if (oldPlacement.contains((Object)NodeLabelPlacement.INSIDE)) {
            newPlacement.add(NodeLabelPlacement.INSIDE);
        } else {
            newPlacement.add(NodeLabelPlacement.OUTSIDE);
        }
        if (!oldPlacement.contains((Object)NodeLabelPlacement.H_PRIORITY)) {
            newPlacement.add(NodeLabelPlacement.H_PRIORITY);
        }
        if (oldPlacement.contains((Object)NodeLabelPlacement.H_LEFT)) {
            newPlacement.add(NodeLabelPlacement.V_TOP);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.H_CENTER)) {
            newPlacement.add(NodeLabelPlacement.V_CENTER);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.H_RIGHT)) {
            newPlacement.add(NodeLabelPlacement.V_BOTTOM);
        }
        if (oldPlacement.contains((Object)NodeLabelPlacement.V_TOP)) {
            newPlacement.add(NodeLabelPlacement.H_LEFT);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.V_CENTER)) {
            newPlacement.add(NodeLabelPlacement.H_CENTER);
        } else if (oldPlacement.contains((Object)NodeLabelPlacement.V_BOTTOM)) {
            newPlacement.add(NodeLabelPlacement.H_RIGHT);
        }
        shape.setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, newPlacement);
    }

    private void transposePortSide(LPort p) {
        p.setSide(this.transposePortSide(p.getSide()));
    }

    private PortSide transposePortSide(PortSide side) {
        switch (side) {
            case NORTH: {
                return PortSide.WEST;
            }
            case WEST: {
                return PortSide.NORTH;
            }
            case SOUTH: {
                return PortSide.EAST;
            }
            case EAST: {
                return PortSide.SOUTH;
            }
        }
        return PortSide.UNDEFINED;
    }

    private void transposeEdgeLabelPlacement(LGraph graph) {
        EdgeLabelSideSelection oldSide = graph.getProperty(LayeredOptions.EDGE_LABELS_SIDE_SELECTION);
        if (oldSide != null) {
            graph.setProperty(LayeredOptions.EDGE_LABELS_SIDE_SELECTION, (Object)oldSide.transpose());
        }
    }

    private void transposeExternalPortSide(LNode node) {
        node.setProperty(InternalProperties.EXT_PORT_SIDE, (Object)this.transposePortSide(node.getProperty(InternalProperties.EXT_PORT_SIDE)));
    }

    private void transposeLayerConstraint(LNode node) {
        LayerConstraint layerConstraint = node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
        InLayerConstraint inLayerConstraint = node.getProperty(InternalProperties.IN_LAYER_CONSTRAINT);
        if (layerConstraint == LayerConstraint.FIRST_SEPARATE) {
            node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
        } else if (layerConstraint == LayerConstraint.LAST_SEPARATE) {
            node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
        } else if (inLayerConstraint == InLayerConstraint.TOP) {
            node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.NONE);
        } else if (inLayerConstraint == InLayerConstraint.BOTTOM) {
            node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
            node.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.NONE);
        }
    }

    private void transposeProperties(LNode node) {
        KVector minSize = node.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
        node.setProperty(LayeredOptions.NODE_SIZE_MINIMUM, new KVector(minSize.y, minSize.x));
        switch (node.getProperty(LayeredOptions.ALIGNMENT)) {
            case LEFT: {
                node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.TOP);
                break;
            }
            case RIGHT: {
                node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.BOTTOM);
                break;
            }
            case TOP: {
                node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.LEFT);
                break;
            }
            case BOTTOM: {
                node.setProperty(LayeredOptions.ALIGNMENT, (Object)Alignment.RIGHT);
            }
        }
        if (node.getAllProperties().containsKey(LayeredOptions.POSITION)) {
            KVector pos = node.getProperty(LayeredOptions.POSITION);
            double tmp = pos.x;
            pos.x = pos.y;
            pos.y = tmp;
        }
    }

    private void reverseIndex(LPort port) {
        Integer index = port.getProperty(LayeredOptions.PORT_INDEX);
        if (index != null) {
            port.setProperty(LayeredOptions.PORT_INDEX, (Object)(-index.intValue()));
        }
    }

    public static enum Mode {
        TO_INTERNAL_LTR,
        TO_INPUT_DIRECTION;

    }
}

