/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;
import net.sourceforge.plantuml.utils.Position;

public abstract class Player {
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private final boolean compact;
    private final Display title;
    private int suggestedHeight;
    private final Stereotype stereotype;
    private final HColor generalBackgroundColor;
    private Panels cached;
    private final List<TimingNote> notes = new ArrayList<TimingNote>();
    private final PlayerFrame playerFrame;
    private final SName sname;

    public final void addNote(TimeTick now, Display note, Position position, Stereotype stereotype) {
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.note);
        Style style = signature.withTOBECHANGED(stereotype).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        this.notes.add(new TimingNote(now, this, note, position, this.skinParam, style));
    }

    public Player(String title, ISkinParam skinParam, TimingRuler ruler, boolean compact, Stereotype stereotype, HColor generalBackgroundColor, SName sname, int suggestedHeight) {
        this.generalBackgroundColor = generalBackgroundColor;
        this.sname = sname;
        this.stereotype = stereotype;
        this.skinParam = skinParam;
        this.compact = compact;
        this.ruler = ruler;
        this.suggestedHeight = suggestedHeight;
        this.title = Display.getWithNewlines(skinParam.getPragma(), title);
        this.playerFrame = new PlayerFrame(this.getTitle(), skinParam, compact);
    }

    protected final Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, this.sname).withTOBECHANGED(this.stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    public final List<TimingNote> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public final TimingRuler getRuler() {
        return this.ruler;
    }

    public final int getSuggestedHeight() {
        return this.suggestedHeight;
    }

    public final boolean isCompact() {
        return this.compact;
    }

    public final HColor getGeneralBackgroundColor() {
        return this.generalBackgroundColor;
    }

    private TextBlock getTitle() {
        if (this.title.isWhite()) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FontConfiguration fontConfiguration = FontConfiguration.create(this.skinParam, StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder()));
        return this.title.create(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3, ArrowConfiguration var4);

    public final void drawFrameTitle(UGraphic ug) {
        this.playerFrame.drawFrameTitle(ug);
    }

    public final double getFrameHeight(StringBounder stringBounder) {
        return this.playerFrame.getHeight(stringBounder);
    }

    public final void setHeight(int height) {
        this.suggestedHeight = height;
    }

    public final Panels panels() {
        if (this.cached == null) {
            this.cached = this.buildPlayerPanels();
        }
        return this.cached;
    }

    protected abstract Panels buildPlayerPanels();
}

