/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.mtermvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.termvectors.Filter;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MultiTermVectorsOperation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, MultiTermVectorsOperation> {
    @Nullable
    private final JsonData doc;
    @Nullable
    private final Boolean fieldStatistics;
    @Nonnull
    private final List<String> fields;
    @Nullable
    private final Filter filter;
    @Nonnull
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MultiTermVectorsOperation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermVectorsOperation::setupMultiTermVectorsOperationDeserializer);

    private MultiTermVectorsOperation(Builder builder) {
        this.doc = builder.doc;
        this.fieldStatistics = builder.fieldStatistics;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.filter = builder.filter;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = builder.index;
        this.offsets = builder.offsets;
        this.payloads = builder.payloads;
        this.positions = builder.positions;
        this.routing = builder.routing;
        this.termStatistics = builder.termStatistics;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MultiTermVectorsOperation of(Function<Builder, ObjectBuilder<MultiTermVectorsOperation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final JsonData doc() {
        return this.doc;
    }

    @Nullable
    public final Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Filter filter() {
        return this.filter;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public final Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public final Boolean positions() {
        return this.positions;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.fieldStatistics != null) {
            generator.writeKey("field_statistics");
            generator.write(this.fieldStatistics.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.offsets != null) {
            generator.writeKey("offsets");
            generator.write(this.offsets.booleanValue());
        }
        if (this.payloads != null) {
            generator.writeKey("payloads");
            generator.write(this.payloads.booleanValue());
        }
        if (this.positions != null) {
            generator.writeKey("positions");
            generator.write(this.positions.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.termStatistics != null) {
            generator.writeKey("term_statistics");
            generator.write(this.termStatistics.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMultiTermVectorsOperationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, JsonData._DESERIALIZER, "doc");
        op.add(Builder::fieldStatistics, JsonpDeserializer.booleanDeserializer(), "field_statistics");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::filter, Filter._DESERIALIZER, "filter");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::offsets, JsonpDeserializer.booleanDeserializer(), "offsets");
        op.add(Builder::payloads, JsonpDeserializer.booleanDeserializer(), "payloads");
        op.add(Builder::positions, JsonpDeserializer.booleanDeserializer(), "positions");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::termStatistics, JsonpDeserializer.booleanDeserializer(), "term_statistics");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.doc);
        result = 31 * result + Objects.hashCode(this.fieldStatistics);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.offsets);
        result = 31 * result + Objects.hashCode(this.payloads);
        result = 31 * result + Objects.hashCode(this.positions);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.termStatistics);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermVectorsOperation other = (MultiTermVectorsOperation)o;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.fieldStatistics, other.fieldStatistics) && Objects.equals(this.fields, other.fields) && Objects.equals(this.filter, other.filter) && this.id.equals(other.id) && Objects.equals(this.index, other.index) && Objects.equals(this.offsets, other.offsets) && Objects.equals(this.payloads, other.payloads) && Objects.equals(this.positions, other.positions) && Objects.equals(this.routing, other.routing) && Objects.equals(this.termStatistics, other.termStatistics) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, MultiTermVectorsOperation> {
        @Nullable
        private JsonData doc;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private List<String> fields;
        @Nullable
        private Filter filter;
        private String id;
        @Nullable
        private String index;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private String routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(MultiTermVectorsOperation o) {
            this.doc = o.doc;
            this.fieldStatistics = o.fieldStatistics;
            this.fields = Builder._listCopy(o.fields);
            this.filter = o.filter;
            this.id = o.id;
            this.index = o.index;
            this.offsets = o.offsets;
            this.payloads = o.payloads;
            this.positions = o.positions;
            this.routing = o.routing;
            this.termStatistics = o.termStatistics;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        private Builder(Builder o) {
            this.doc = o.doc;
            this.fieldStatistics = o.fieldStatistics;
            this.fields = Builder._listCopy(o.fields);
            this.filter = o.filter;
            this.id = o.id;
            this.index = o.index;
            this.offsets = o.offsets;
            this.payloads = o.payloads;
            this.positions = o.positions;
            this.routing = o.routing;
            this.termStatistics = o.termStatistics;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder doc(@Nullable JsonData value) {
            this.doc = value;
            return this;
        }

        @Nonnull
        public final Builder fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable Filter value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filter(fn.apply(new Filter.Builder()).build());
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        @Nonnull
        public final Builder payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        @Nonnull
        public final Builder positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        @Nonnull
        public MultiTermVectorsOperation build() {
            this._checkSingleUse();
            return new MultiTermVectorsOperation(this);
        }
    }
}

