/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ2\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0086@\u00a2\u0006\u0002\u0010!J$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010#JD\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0086@\u00a2\u0006\u0002\u0010&J\u001a\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u001cJ\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0+H\u0086@\u00a2\u0006\u0002\u0010,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "services", "", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/IndexMetadataService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Ljava/util/Map;)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getServices", "()Ljava/util/Map;", "restrictedIndexPattern", "kotlin.jvm.PlatformType", "isUnManageableIndex", "", "index", "getISMIndexMetadataByType", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ISMIndexMetadata;", "type", "indexNames", "", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllISMIndexMetadataByType", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMultiTypeISMIndexMetadata", "types", "(Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addMetadataServices", "", "newServices", "getAllISMIndexMetadata", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIndexMetadataWriteOverrideSettings", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nIndexMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexMetadataProvider.kt\norg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n295#2,2:103\n1617#2,9:105\n1869#2:114\n1870#2:116\n1626#2:117\n1#3:115\n*S KotlinDebug\n*F\n+ 1 IndexMetadataProvider.kt\norg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider\n*L\n71#1:103,2\n91#1:105,9\n91#1:114\n91#1:116\n91#1:117\n91#1:115\n*E\n"})
public final class IndexMetadataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Map<String, IndexMetadataService> services;
    private volatile String restrictedIndexPattern;
    @NotNull
    public static final String EVALUATION_FAILURE_MESSAGE = "Matches restricted index pattern defined in the cluster setting";
    @NotNull
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot get metadata for more than one index name/pattern when using a custom index type";

    public IndexMetadataProvider(@NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull Map<String, IndexMetadataService> services) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.services = services;
        this.restrictedIndexPattern = (String)ManagedIndexSettings.Companion.getRESTRICTED_INDEX_PATTERN().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getRESTRICTED_INDEX_PATTERN(), arg_0 -> IndexMetadataProvider._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Map<String, IndexMetadataService> getServices() {
        return this.services;
    }

    public final boolean isUnManageableIndex(@NotNull String index2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        String string = this.restrictedIndexPattern;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"restrictedIndexPattern");
        return new Regex(string).matches((CharSequence)index2);
    }

    @Nullable
    public final Object getISMIndexMetadataByType(@NotNull String type, @NotNull List<String> indexNames, @NotNull Continuation<? super Map<String, ISMIndexMetadata>> $completion) {
        IndexMetadataService indexMetadataService = this.services.get(type);
        if (indexMetadataService == null) {
            throw new IllegalArgumentException(Companion.getTypeNotRecognizedMessage(type));
        }
        IndexMetadataService service = indexMetadataService;
        if (!Intrinsics.areEqual((Object)type, (Object)"_default") && indexNames.size() > 1) {
            throw new IllegalArgumentException(MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR);
        }
        return service.getMetadata(indexNames, this.client, this.clusterService, $completion);
    }

    public static /* synthetic */ Object getISMIndexMetadataByType$default(IndexMetadataProvider indexMetadataProvider, String string, List list, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = "_default";
        }
        return indexMetadataProvider.getISMIndexMetadataByType(string, list, (Continuation<? super Map<String, ISMIndexMetadata>>)continuation);
    }

    @Nullable
    public final Object getAllISMIndexMetadataByType(@NotNull String type, @NotNull Continuation<? super Map<String, ISMIndexMetadata>> $completion) {
        IndexMetadataService indexMetadataService = this.services.get(type);
        if (indexMetadataService == null) {
            throw new IllegalArgumentException(Companion.getTypeNotRecognizedMessage(type));
        }
        IndexMetadataService service = indexMetadataService;
        return service.getMetadataForAllIndices(this.client, this.clusterService, $completion);
    }

    public static /* synthetic */ Object getAllISMIndexMetadataByType$default(IndexMetadataProvider indexMetadataProvider, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = "_default";
        }
        return indexMetadataProvider.getAllISMIndexMetadataByType(string, (Continuation<? super Map<String, ISMIndexMetadata>>)continuation);
    }

    @Nullable
    public final Object getMultiTypeISMIndexMetadata(@NotNull List<String> types, @NotNull List<String> indexNames, @NotNull Continuation<? super Map<String, ? extends Map<String, ISMIndexMetadata>>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends Map<String, ? extends ISMIndexMetadata>>>, Object>(types, indexNames, this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<String> $types;
            final /* synthetic */ List<String> $indexNames;
            final /* synthetic */ IndexMetadataProvider this$0;
            {
                this.$types = $types;
                this.$indexNames = $indexNames;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$any$iv = this.$types;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl11
                        v0 = false;
                        ** GOTO lbl18
lbl11:
                        // 2 sources

                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-IndexMetadataProvider$getMultiTypeISMIndexMetadata$2$1 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)"_default") == false)) continue;
                            v0 = true;
                            ** GOTO lbl18
                        }
                        v0 = false;
lbl18:
                        // 3 sources

                        if (v0 && this.$indexNames.size() > 1) {
                            throw new IllegalArgumentException("Cannot get metadata for more than one index name/pattern when using a custom index type");
                        }
                        requests = new ArrayList<Deferred>();
                        $i$f$any = this.$types;
                        var5_8 = this.this$0;
                        var6_9 = this.$indexNames;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            type = (String)element$iv;
                            $i$a$-forEach-IndexMetadataProvider$getMultiTypeISMIndexMetadata$2$2 = false;
                            requests.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends Map<String, ? extends ISMIndexMetadata>>>, Object>(type, var5_8, var6_9, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ String $type;
                                final /* synthetic */ IndexMetadataProvider this$0;
                                final /* synthetic */ List<String> $indexNames;
                                {
                                    this.$type = $type;
                                    this.this$0 = $receiver;
                                    this.$indexNames = $indexNames;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            String string = this.$type;
                                            this.L$0 = string;
                                            this.label = 1;
                                            Object object2 = this.this$0.getISMIndexMetadataByType(this.$type, this.$indexNames, (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                                            if (object2 != object) return TuplesKt.to((Object)string, (Object)object2);
                                            return object;
                                        }
                                        case 1: {
                                            String string = (String)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return TuplesKt.to((Object)string, (Object)object2);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<String, ? extends Map<String, ISMIndexMetadata>>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(requests);
                        this.label = 1;
                        v1 = AwaitKt.awaitAll((Collection)requests, (Continuation)((Continuation)this));
                        if (v1 == var12_3) {
                            return var12_3;
                        }
                        ** GOTO lbl43
                    }
                    case 1: {
                        requests = (ArrayList)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl43:
                        // 2 sources

                        return MapsKt.toMap((Iterable)((Iterable)v1));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, ? extends Map<String, ISMIndexMetadata>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object getMultiTypeISMIndexMetadata$default(IndexMetadataProvider indexMetadataProvider, List list, List list2, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.toList((Iterable)indexMetadataProvider.services.keySet());
        }
        return indexMetadataProvider.getMultiTypeISMIndexMetadata(list, list2, (Continuation<? super Map<String, ? extends Map<String, ISMIndexMetadata>>>)continuation);
    }

    public final void addMetadataServices(@NotNull Map<String, ? extends IndexMetadataService> newServices) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(newServices, (String)"newServices");
            Iterable $this$firstOrNull$iv = newServices.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!this.services.containsKey(it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String duplicateIndexType = v0;
        if (duplicateIndexType != null) {
            throw new IllegalArgumentException(Companion.getDuplicateServicesMessage(duplicateIndexType));
        }
        this.services.putAll(newServices);
    }

    @Nullable
    public final Object getAllISMIndexMetadata(@NotNull Continuation<? super Set<ISMIndexMetadata>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<ISMIndexMetadata>>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IndexMetadataProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        metadata = new LinkedHashSet<E>();
                        requests = new ArrayList<Deferred>();
                        var5_6 = this.this$0.getServices();
                        var6_7 = this.this$0;
                        $i$f$forEach = false;
                        var8_11 = $this$forEach$iv.entrySet().iterator();
                        while (var8_11.hasNext()) {
                            var10_13 = element$iv = var8_11.next();
                            $i$a$-forEach-IndexMetadataProvider$getAllISMIndexMetadata$2$1 = false;
                            service = (IndexMetadataService)var10_13.getValue();
                            requests.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ISMIndexMetadata>>, Object>(service, var6_7, null){
                                int label;
                                final /* synthetic */ IndexMetadataService $service;
                                final /* synthetic */ IndexMetadataProvider this$0;
                                {
                                    this.$service = $service;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$service.getMetadataForAllIndices(this.this$0.getClient(), this.this$0.getClusterService(), (Continuation)this);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, ISMIndexMetadata>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.L$1 = metadata;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(requests);
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)requests, (Continuation)((Continuation)this));
                        if (v0 == var13_3) {
                            return var13_3;
                        }
                        ** GOTO lbl33
                    }
                    case 1: {
                        requests = (ArrayList<Deferred>)this.L$2;
                        metadata = (Set)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        $this$forEach$iv = (Iterable)v0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Map)element$iv;
                            $i$a$-forEach-IndexMetadataProvider$getAllISMIndexMetadata$2$2 = false;
                            metadata.addAll(it.values());
                        }
                        return metadata;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Set<ISMIndexMetadata>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getIndexMetadataWriteOverrideSettings() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.services.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IndexMetadataService it = (IndexMetadataService)element$iv$iv;
            boolean bl2 = false;
            if (it.getIndexMetadataWriteOverrideSetting() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void _init_$lambda$0(IndexMetadataProvider this$0, String it) {
        this$0.restrictedIndexPattern = it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider$Companion;", "", "<init>", "()V", "EVALUATION_FAILURE_MESSAGE", "", "MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR", "getTypeNotRecognizedMessage", "indexType", "getDuplicateServicesMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTypeNotRecognizedMessage(@NotNull String indexType) {
            Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
            return "Index type [type=" + indexType + "] was not recognized when trying to get index metadata";
        }

        @NotNull
        public final String getDuplicateServicesMessage(@NotNull String indexType) {
            Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
            return "Multiple metadata services attempted to assign a service to the index type [" + indexType + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

