/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.List;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineExceptionHandlerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"handlers", "", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "handleCoroutineExceptionImpl", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "kotlinx-coroutines-core"})
public final class CoroutineExceptionHandlerImplKt {
    private static final List<CoroutineExceptionHandler> handlers;

    public static final void handleCoroutineExceptionImpl(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Thread currentThread;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        for (CoroutineExceptionHandler handler : handlers) {
            try {
                handler.handleException(context, exception);
            }
            catch (Throwable t) {
                Thread currentThread2;
                Thread thread = currentThread2 = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
                thread.getUncaughtExceptionHandler().uncaughtException(currentThread2, CoroutineExceptionHandlerKt.handlerException(exception, t));
            }
        }
        Thread thread = currentThread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
        thread.getUncaughtExceptionHandler().uncaughtException(currentThread, exception);
    }

    static {
        Class<CoroutineExceptionHandler> clazz;
        Class<CoroutineExceptionHandler> serviceClass = clazz = CoroutineExceptionHandler.class;
        boolean bl = false;
        ServiceLoader<CoroutineExceptionHandler> serviceLoader = ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(servi\u2026serviceClass.classLoader)");
        handlers = CollectionsKt.toList((Iterable)serviceLoader);
    }
}

