/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1GenericPrimitive;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.util.Utils;

public class AuthorityKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID f = PKIX.S;
    private byte[] g = null;
    private ArrayList<GeneralName> h = null;
    private BigInteger i = null;

    public AuthorityKeyIDExtension() {
        super(f);
    }

    public AuthorityKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public AuthorityKeyIDExtension(byte[] byArray, boolean bl) {
        super(f, bl);
        this.g = byArray;
        this.a(this.h());
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger) {
        this(generalName, bigInteger, false);
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger, boolean bl) {
        super(f, bl);
        this.h = new ArrayList();
        this.h.add(generalName);
        this.i = bigInteger;
        this.a(this.h());
    }

    public AuthorityKeyIDExtension(List<GeneralName> list, BigInteger bigInteger) {
        this(list, bigInteger, false);
    }

    public AuthorityKeyIDExtension(List<GeneralName> list, BigInteger bigInteger, boolean bl) {
        super(f, bl);
        this.h = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.i = bigInteger;
        this.a(this.h());
    }

    public AuthorityKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public byte[] e() {
        if (!this.e) {
            this.i();
        }
        return this.g;
    }

    public ArrayList<GeneralName> f() {
        if (!this.e) {
            this.i();
        }
        return this.h;
    }

    public BigInteger g() {
        if (!this.e) {
            this.i();
        }
        return this.i;
    }

    private byte[] h() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.g != null) {
            aSN1Sequence.a(new ASN1GenericPrimitive(this.g, 0));
        }
        if (this.h != null && this.i != null) {
            aSN1Sequence.a(new ASN1GenericConstructed(this.h, 1));
            aSN1Sequence.a(new ASN1GenericPrimitive(new ASN1Integer(this.i), 2));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.e = true;
        return byArray;
    }

    private void i() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.d());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            if (aSN1SequenceInputStream.d() == 0) {
                aSN1SequenceInputStream.a(4);
                this.g = ASN1OctetString.a(aSN1SequenceInputStream);
            } else {
                this.g = null;
            }
            if (this.g == null || aSN1SequenceInputStream.a()) {
                if (aSN1SequenceInputStream.d() == 1) {
                    aSN1SequenceInputStream.a(16);
                    ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                    this.h = new ArrayList();
                    while (aSN1SequenceInputStream2.a()) {
                        this.h.add(new GeneralName(aSN1SequenceInputStream2));
                    }
                    aSN1SequenceInputStream2.b();
                } else {
                    this.h = null;
                }
                if (aSN1SequenceInputStream.d() == 2) {
                    aSN1SequenceInputStream.a(2);
                    this.i = ASN1Integer.b(aSN1SequenceInputStream);
                } else {
                    this.i = null;
                }
            } else {
                this.h = null;
                this.i = null;
            }
            aSN1SequenceInputStream.b();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.e = true;
    }

    @Override
    public String toString() {
        if (!this.e) {
            this.i();
        }
        StringBuffer stringBuffer = new StringBuffer("authorityKeyIDExtension {oid = " + f.d() + ", critical = " + this.c() + ", value = [");
        boolean bl = false;
        if (this.e() != null) {
            stringBuffer.append("keyID = " + Utils.toHexString(this.e()));
            bl = true;
        }
        if (this.g() != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("serialNo = " + this.g());
            bl = true;
        }
        if (this.h != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("issuer = {");
            boolean bl2 = false;
            int n = this.h.size();
            for (int i = 0; i < n; ++i) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.h.get(i).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

