(*
 * Interface of rtl info extraction from instructions.
 * The code matching this interface is automatically generated by the MDL tool.
 *)
signature RTL_PROPERTIES =
sig

   structure I   : INSTRUCTIONS
   structure C   : CELLS
   structure RTL : MLTREE_RTL
   structure OT  : OPERAND_TABLE
      sharing I.C            = C
      sharing OT.I           = I
      sharing RTL.T          = I.T

   datatype value = 
     CELL    of C.cell    (* a single value *)
   | OPERAND of I.operand (* a complex operand *)

   (* Return the RTL describing the semantics of an instruction 
    * The rtl returned is in lambda-lifted form, i.e. it contains
    * references to PARAM n, which refers to the nth input or output parameter.
    *)
   val rtl : I.instruction -> RTL.rtl  

   (*
    *  Return the input/ouput parameters of an instruction. 
    *  The input/output matches positionally with the info returned by
    *  the function rtl.
    *) 
   val defUse : OT.valueNumberMethods -> I.instruction 
                   -> value list * value list

end
