// This file is part of libigl, a simple c++ geometry processing library.
// 
// Copyright (C) 2013 Alec Jacobson <alecjacobson@gmail.com>
// 
// This Source Code Form is subject to the terms of the Mozilla Public License 
// v. 2.0. If a copy of the MPL was not distributed with this file, You can 
// obtain one at http://mozilla.org/MPL/2.0/.
#ifndef IGL_READNODE_H
#define IGL_READNODE_H
#include "igl_inline.h"

#include <string>
#include <vector>
#include <Eigen/Core>

namespace igl
{
  /// load a list of points from a .node file
  ///
  /// @tparam Scalar  type for positions and vectors (will be read as double and cast
  ///     to Scalar)
  /// @tparam Index  type for indices (will be read as int and cast to Index)
  /// @param[in] node_file_name  path of .node file
  /// @param[out] V  double matrix of vertex positions  #V by dim
  /// @param[out] I  list of indices (first tells whether 0 or 1 indexed)
  template <typename DerivedV, typename DerivedI>
  IGL_INLINE bool readNODE(
    const std::string node_file_name,
    Eigen::PlainObjectBase<DerivedV>& V,
    Eigen::PlainObjectBase<DerivedI>& I);
  /// \overload
  template <typename Scalar, typename Index>
  IGL_INLINE bool readNODE(
    const std::string node_file_name,
    std::vector<std::vector<Scalar > > & V,
    std::vector<std::vector<Index > > & I);
}

#ifndef IGL_STATIC_LIBRARY
#  include "readNODE.cpp"
#endif

#endif
