/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.formatting;

import org.aesh.readline.terminal.formatting.CharacterType;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalTextStyle;

public class TerminalCharacter {
    private char character;
    private TerminalTextStyle style;
    private TerminalColor color;
    private String cache;

    public TerminalCharacter(char c) {
        this(c, new TerminalTextStyle());
    }

    public TerminalCharacter(char c, TerminalTextStyle style) {
        this(c, new TerminalColor(), style);
    }

    public TerminalCharacter(char c, TerminalColor color) {
        this(c, color, new TerminalTextStyle());
    }

    public TerminalCharacter(char c, TerminalColor color, CharacterType type) {
        this(c, color, new TerminalTextStyle(type));
    }

    public TerminalCharacter(char c, TerminalColor color, TerminalTextStyle style) {
        this.character = c;
        this.style = style;
        this.color = color;
    }

    public char getCharacter() {
        return this.character;
    }

    public void setCharacter(char c) {
        this.character = c;
        this.cache = null;
    }

    public TerminalTextStyle getStyle() {
        return this.style;
    }

    public String toString(TerminalCharacter prev) {
        if (this.equalsIgnoreCharacter(prev)) {
            return String.valueOf(this.character);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[");
        if (!this.style.equals(prev.getStyle())) {
            builder.append(this.style.getValueComparedToPrev(prev.getStyle()));
        }
        if (!this.color.equals(prev.color)) {
            if (prev.getStyle().isInvert()) {
                if (builder.charAt(builder.length() - 1) == '[') {
                    builder.append(this.color.toString());
                } else {
                    builder.append(';').append(this.color.toString());
                }
            } else if (builder.charAt(builder.length() - 1) == '[') {
                builder.append(this.color.toString(prev.color));
            } else {
                builder.append(';').append(this.color.toString(prev.color));
            }
        }
        builder.append('m');
        builder.append(this.getCharacter());
        return builder.toString();
    }

    public String toString() {
        if (this.cache == null) {
            this.cache = "\u001b[" + this.style.toString() + ';' + this.color.toString() + 'm' + this.getCharacter();
        }
        return this.cache;
    }

    public boolean equalsIgnoreCharacter(TerminalCharacter that) {
        return this.style.equals(that.style) && this.color.equals(that.color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TerminalCharacter)) {
            return false;
        }
        TerminalCharacter that = (TerminalCharacter)o;
        return this.style.equals(that.style) && this.character == that.character && this.color.equals(that.color);
    }

    public int hashCode() {
        int result = this.character;
        result = 31 * result + this.color.hashCode();
        result = 31 * result + this.style.hashCode();
        return result;
    }
}

