/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;
import java.util.function.BiFunction;

final class BinOp
extends Item {
    private final Item a;
    private final Item b;
    private final Kind kind;

    BinOp(Expr a, Expr b, Kind kind) {
        switch (kind.operands) {
            case SAME: {
                Optional<ClassDesc> promotedType = Conversions.numericPromotion(a.type(), b.type());
                if (promotedType.isPresent()) {
                    this.a = Conversions.convert(a, promotedType.get());
                    this.b = Conversions.convert(b, promotedType.get());
                    break;
                }
                throw new IllegalArgumentException("Operation " + String.valueOf((Object)kind) + " expects both operands to have the same type: " + a.type().displayName() + ", " + b.type().displayName());
            }
            case SECOND_INT: {
                if (ConstantDescs.CD_int.equals(Conversions.unboxingConversion(b.type()).orElse(b.type()))) {
                    this.a = Conversions.convert(a, Conversions.unboxingConversion(a.type()).orElse(a.type()));
                    this.b = Conversions.convert(b, ConstantDescs.CD_int);
                    break;
                }
                throw new IllegalArgumentException("Operation " + String.valueOf((Object)kind) + " expects second operand to be int: " + b.type().displayName());
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)kind.operands));
            }
        }
        this.kind = kind;
        if (!kind.isValidFor(this.typeKind())) {
            throw new IllegalArgumentException("Operation " + String.valueOf((Object)kind) + " is not valid for type kind of " + String.valueOf((Object)this.typeKind()));
        }
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.a.process(this.b.process(node.prev(), op), op);
    }

    @Override
    public ClassDesc type() {
        return this.a.type();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Operation op = this.kind.opFor(this.typeKind());
        assert (op != null);
        op.apply(cb);
    }

    @Override
    public StringBuilder toShortString(StringBuilder sb) {
        return this.b.toShortString(this.a.toShortString(sb).append((Object)this.kind));
    }

    static enum Kind {
        ADD(Operands.SAME, CodeBuilder::iadd, CodeBuilder::ladd, CodeBuilder::fadd, CodeBuilder::dadd, "+"),
        SUB(Operands.SAME, CodeBuilder::isub, CodeBuilder::lsub, CodeBuilder::fsub, CodeBuilder::dsub, "-"),
        MUL(Operands.SAME, CodeBuilder::imul, CodeBuilder::lmul, CodeBuilder::fmul, CodeBuilder::dmul, "*"),
        DIV(Operands.SAME, CodeBuilder::idiv, CodeBuilder::ldiv, CodeBuilder::fdiv, CodeBuilder::ddiv, "/"),
        REM(Operands.SAME, CodeBuilder::irem, CodeBuilder::lrem, CodeBuilder::frem, CodeBuilder::drem, "%"),
        AND(Operands.SAME, CodeBuilder::iand, CodeBuilder::land, "&"),
        OR(Operands.SAME, CodeBuilder::ior, CodeBuilder::lor, "|"),
        XOR(Operands.SAME, CodeBuilder::ixor, CodeBuilder::lxor, "^"),
        SHL(Operands.SECOND_INT, CodeBuilder::ishl, CodeBuilder::lshl, "<<"),
        SHR(Operands.SECOND_INT, CodeBuilder::ishr, CodeBuilder::lshr, ">>"),
        USHR(Operands.SECOND_INT, CodeBuilder::iushr, CodeBuilder::lushr, ">>>");

        final Operands operands;
        final Operation intOp;
        final Operation longOp;
        final Operation floatOp;
        final Operation doubleOp;
        final String symbol;

        private Kind(Operands operands, Operation intOp, Operation longOp, Operation floatOp, Operation doubleOp, String symbol) {
            this.operands = operands;
            this.intOp = intOp;
            this.longOp = longOp;
            this.floatOp = floatOp;
            this.doubleOp = doubleOp;
            this.symbol = symbol;
        }

        private Kind(Operands operands, Operation intOp, Operation longOp, String symbol) {
            this(operands, intOp, longOp, null, null, symbol);
        }

        Operation opFor(TypeKind tk) {
            return switch (tk.asLoadable()) {
                case TypeKind.INT -> this.intOp;
                case TypeKind.LONG -> this.longOp;
                case TypeKind.FLOAT -> this.floatOp;
                case TypeKind.DOUBLE -> this.doubleOp;
                default -> null;
            };
        }

        boolean isValidFor(TypeKind tk) {
            return null != this.opFor(tk);
        }

        public String toString() {
            return this.symbol;
        }
    }

    static enum Operands {
        SAME,
        SECOND_INT;

    }

    static interface Operation {
        public void apply(CodeBuilder var1);
    }
}

