/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class ColumnReference
implements Expression,
Assignable {
    private final @Nullable String qualifier;
    private final String columnExpression;
    private final @Nullable SelectablePath selectablePath;
    private final boolean isFormula;
    private final @Nullable String readExpression;
    private final JdbcMapping jdbcMapping;

    public ColumnReference(TableReference tableReference, SelectableMapping selectableMapping) {
        this(tableReference.getIdentificationVariable(), selectableMapping.getSelectionExpression(), selectableMapping.getSelectablePath(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getJdbcMapping());
    }

    public ColumnReference(TableReference tableReference, String mapping, JdbcMapping jdbcMapping) {
        this(tableReference.getIdentificationVariable(), mapping, null, false, null, jdbcMapping);
    }

    public ColumnReference(@Nullable String qualifier, SelectableMapping selectableMapping) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.getSelectablePath(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getJdbcMapping());
    }

    public ColumnReference(@Nullable String qualifier, SelectableMapping selectableMapping, JdbcMapping jdbcMapping) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.getSelectablePath(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), jdbcMapping);
    }

    public ColumnReference(TableReference tableReference, String columnExpression, boolean isFormula, @Nullable String customReadExpression, JdbcMapping jdbcMapping) {
        this(tableReference.getIdentificationVariable(), columnExpression, null, isFormula, customReadExpression, jdbcMapping);
    }

    public ColumnReference(@Nullable String qualifier, String columnExpression, boolean isFormula, @Nullable String customReadExpression, JdbcMapping jdbcMapping) {
        this(qualifier, columnExpression, null, isFormula, customReadExpression, jdbcMapping);
    }

    public ColumnReference(@Nullable String qualifier, String columnExpression, @Nullable SelectablePath selectablePath, boolean isFormula, @Nullable String customReadExpression, JdbcMapping jdbcMapping) {
        this.qualifier = StringHelper.nullIfEmpty(qualifier);
        this.columnExpression = isFormula ? (qualifier == null ? StringHelper.replace(columnExpression, "{@}.", "") : StringHelper.replace(columnExpression, "{@}", qualifier)) : columnExpression;
        this.selectablePath = selectablePath == null ? new SelectablePath(this.columnExpression) : selectablePath;
        this.isFormula = isFormula;
        this.readExpression = customReadExpression;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public ColumnReference getColumnReference() {
        return this;
    }

    public @Nullable String getQualifier() {
        return this.qualifier;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public @Nullable String getReadExpression() {
        return this.readExpression;
    }

    public @Nullable String getSelectableName() {
        return this.selectablePath == null ? null : this.selectablePath.getSelectableName();
    }

    public @Nullable SelectablePath getSelectablePath() {
        return this.selectablePath;
    }

    public boolean isColumnExpressionFormula() {
        return this.isFormula;
    }

    public String getExpressionText() {
        StringBuilder sb = new StringBuilder();
        this.appendReadExpression(new StringBuilderSqlAppender(sb));
        return sb.toString();
    }

    public void appendReadExpression(SqlAppender appender) {
        this.appendReadExpression(appender, this.qualifier);
    }

    public void appendReadExpression(@Nullable String qualifier, Consumer<String> appender) {
        if (this.isFormula) {
            appender.accept(this.columnExpression);
        } else if (this.readExpression != null) {
            appender.accept(qualifier == null ? StringHelper.replace(this.readExpression, "{@}.", "") : StringHelper.replace(this.readExpression, "{@}", qualifier));
        } else {
            if (qualifier != null) {
                appender.accept(qualifier);
                appender.accept(".");
            }
            appender.accept(this.columnExpression);
        }
    }

    public void appendReadExpression(SqlAppender appender, @Nullable String qualifier) {
        this.appendReadExpression(qualifier, appender::appendSql);
    }

    public void appendColumnForWrite(SqlAppender appender) {
        this.appendColumnForWrite(appender, this.qualifier);
    }

    public void appendColumnForWrite(SqlAppender appender, @Nullable String qualifier) {
        if (qualifier != null) {
            appender.append(qualifier);
            appender.append('.');
        }
        appender.append(this.columnExpression);
    }

    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JdbcMapping getExpressionType() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        interpreter.visitColumnReference(this);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.getExpressionText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnReference that = (ColumnReference)o;
        return this.isFormula == that.isFormula && Objects.equals(this.qualifier, that.qualifier) && Objects.equals(this.columnExpression, that.columnExpression) && Objects.equals(this.readExpression, that.readExpression);
    }

    public int hashCode() {
        int result = this.qualifier != null ? this.qualifier.hashCode() : 0;
        result = 31 * result + (this.columnExpression != null ? this.columnExpression.hashCode() : 0);
        result = 31 * result + (this.isFormula ? 1 : 0);
        result = 31 * result + (this.readExpression != null ? this.readExpression.hashCode() : 0);
        return result;
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this);
    }
}

