/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;

public class QuotaUtils {
    public static long throttleTime(QuotaViolationException e, long timeMs) {
        double difference = e.value() - e.bound();
        double throttleTimeMs = difference / e.bound() * (double)QuotaUtils.windowSize(e.metric(), timeMs);
        return Math.round(throttleTimeMs);
    }

    public static long boundedThrottleTime(QuotaViolationException e, long maxThrottleTime, long timeMs) {
        return Math.min(QuotaUtils.throttleTime(e, timeMs), maxThrottleTime);
    }

    private static long windowSize(KafkaMetric metric, long timeMs) {
        return QuotaUtils.measurableAsRate(metric.metricName(), metric.measurable()).windowSize(metric.config(), timeMs);
    }

    private static Rate measurableAsRate(MetricName name, Measurable measurable) {
        if (measurable instanceof Rate) {
            return (Rate)measurable;
        }
        throw new IllegalArgumentException("Metric " + String.valueOf(name) + " is not a Rate metric, value " + String.valueOf(measurable));
    }
}

