/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.FileWatcher;
import org.gradle.fileevents.internal.OsxFileEventFunctions;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.HierarchicalFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public class DarwinFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<OsxFileEventFunctions, OsxFileEventFunctions.OsxFileWatcher> {
    public DarwinFileWatcherRegistryFactory(AbstractFileWatcherRegistryFactory.FileEventFunctionsLookup fileEvents, Predicate<String> immutableLocationsFilter) throws NativeIntegrationUnavailableException {
        super(fileEvents.getFileEventFunctions(OsxFileEventFunctions.class), immutableLocationsFilter);
    }

    @Override
    protected OsxFileEventFunctions.OsxFileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return (OsxFileEventFunctions.OsxFileWatcher)((OsxFileEventFunctions)this.fileEventFunctions).newWatcher(fileEvents).withLatency(20L, TimeUnit.MICROSECONDS).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(OsxFileEventFunctions.OsxFileWatcher watcher, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies) {
        return new HierarchicalFileWatcherUpdater((FileWatcher)watcher, DarwinFileWatcherRegistryFactory::validateLocationToWatch, probeRegistry, watchableHierarchies, root -> Collections.emptyList());
    }

    private static void validateLocationToWatch(File location) {
        try {
            String canonicalPath = location.getCanonicalPath();
            String absolutePath = location.getAbsolutePath();
            if (!canonicalPath.equals(absolutePath)) {
                throw new WatchingNotSupportedException(String.format("Unable to watch '%s' since itself or one of its parent is a symbolic link (canonical path: '%s')", absolutePath, canonicalPath));
            }
        }
        catch (IOException e) {
            throw new WatchingNotSupportedException("Unable to watch '%s' since its canonical path can't be resolved: " + e.getMessage(), e);
        }
    }
}

