/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.dirtyFiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.dirtyFiles.ChangesDetectionUtilsKt;
import org.jetbrains.kotlin.incremental.dirtyFiles.ImpactedFilesDeterminer;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/incremental/dirtyFiles/HistoryFilesBasedImpactDeterminer;", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/ImpactedFilesDeterminer;", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "abiSnapshots", "", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "modulesApiHistory", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "buildHistoryFile", "Ljava/io/File;", "lastBuildInfoFile", "icFeatures", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;Ljava/util/Map;Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationFeatures;Lorg/jetbrains/kotlin/build/report/BuildReporter;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "verifyBuildHistoryFilesState", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "determineChangedAndImpactedSymbols", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nHistoryFilesBasedImpactDeterminer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryFilesBasedImpactDeterminer.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/HistoryFilesBasedImpactDeterminer\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n34#2,5:81\n1563#3:86\n1634#3,2:87\n1636#3:90\n1#4:89\n*S KotlinDebug\n*F\n+ 1 HistoryFilesBasedImpactDeterminer.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/HistoryFilesBasedImpactDeterminer\n*L\n54#1:81,5\n63#1:86\n63#1:87,2\n63#1:90\n*E\n"})
public final class HistoryFilesBasedImpactDeterminer
implements ImpactedFilesDeterminer {
    @NotNull
    private final K2JVMCompilerArguments args;
    @NotNull
    private final IncrementalJvmCachesManager caches;
    @NotNull
    private final ChangedFiles.DeterminableFiles.Known changedFiles;
    @NotNull
    private final Map<String, AbiSnapshot> abiSnapshots;
    @NotNull
    private final ModulesApiHistory modulesApiHistory;
    @Nullable
    private final File buildHistoryFile;
    @NotNull
    private final File lastBuildInfoFile;
    @NotNull
    private final IncrementalCompilationFeatures icFeatures;
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;
    @NotNull
    private final MessageCollector messageCollector;

    public HistoryFilesBasedImpactDeterminer(@NotNull K2JVMCompilerArguments args, @NotNull IncrementalJvmCachesManager caches, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull Map<String, ? extends AbiSnapshot> abiSnapshots, @NotNull ModulesApiHistory modulesApiHistory, @Nullable File buildHistoryFile, @NotNull File lastBuildInfoFile, @NotNull IncrementalCompilationFeatures icFeatures, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)changedFiles, (String)"changedFiles");
        Intrinsics.checkNotNullParameter(abiSnapshots, (String)"abiSnapshots");
        Intrinsics.checkNotNullParameter((Object)modulesApiHistory, (String)"modulesApiHistory");
        Intrinsics.checkNotNullParameter((Object)lastBuildInfoFile, (String)"lastBuildInfoFile");
        Intrinsics.checkNotNullParameter((Object)icFeatures, (String)"icFeatures");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.args = args;
        this.caches = caches;
        this.changedFiles = changedFiles;
        this.abiSnapshots = abiSnapshots;
        this.modulesApiHistory = modulesApiHistory;
        this.buildHistoryFile = buildHistoryFile;
        this.lastBuildInfoFile = lastBuildInfoFile;
        this.icFeatures = icFeatures;
        this.reporter = reporter;
        this.messageCollector = messageCollector;
    }

    private final BuildAttribute verifyBuildHistoryFilesState() {
        if (this.buildHistoryFile == null) {
            throw new IllegalStateException("The build is configured to use the build-history based IC approach, but doesn't specify the buildHistoryFile".toString());
        }
        if (!this.icFeatures.getWithAbiSnapshot() && !this.buildHistoryFile.isFile()) {
            return BuildAttribute.NO_BUILD_HISTORY;
        }
        if (!this.lastBuildInfoFile.exists()) {
            return BuildAttribute.NO_LAST_BUILD_INFO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ChangesEither determineChangedAndImpactedSymbols() {
        void $this$measure$iv;
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = GradleBuildTime.IC_ANALYZE_CHANGES_IN_DEPENDENCIES;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            void $this$mapTo$iv$iv;
            BuildInfo buildInfo;
            boolean bl = false;
            BuildAttribute buildAttribute = this.verifyBuildHistoryFilesState();
            if (buildAttribute != null) {
                BuildAttribute rebuildReason = buildAttribute;
                boolean bl2 = false;
                ChangesEither changesEither = new ChangesEither.Unknown(rebuildReason);
                return changesEither;
            }
            if (BuildInfo.Companion.read(this.lastBuildInfoFile, this.messageCollector) == null) {
                ChangesEither changesEither = new ChangesEither.Unknown(BuildAttribute.INVALID_LAST_BUILD_INFO);
                return changesEither;
            }
            BuildInfo lastBuildInfo = buildInfo;
            ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)() -> HistoryFilesBasedImpactDeterminer.determineChangedAndImpactedSymbols$lambda$0$1(lastBuildInfo)));
            Iterable $this$map$iv = this.caches.getLookupCache().getLookupSymbols();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CharSequence charSequence;
                void it;
                LookupSymbolKey lookupSymbolKey = (LookupSymbolKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence2 = it.getScope();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl4 = false;
                    charSequence = it.getName();
                } else {
                    charSequence = charSequence2;
                }
                collection.add((String)charSequence);
            }
            List scopes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            ChangesEither changesEither = ChangesDetectionUtilsKt.getClasspathChanges(CompilerRunnerUtils.getClasspathAsList(this.args), this.changedFiles, lastBuildInfo, this.modulesApiHistory, this.reporter, this.abiSnapshots, this.icFeatures.getWithAbiSnapshot(), this.caches.getPlatformCache(), scopes);
            return changesEither;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    private static final String determineChangedAndImpactedSymbols$lambda$0$1(BuildInfo $lastBuildInfo) {
        return "Last Kotlin Build info -- " + $lastBuildInfo;
    }
}

