/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.java.symbols.FirJavaOverriddenSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u00020\u0007R\u00020\tj\u0006\u0010\b\u001a\u00020\u0007j\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirUnsupportedSyntheticCallableReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;)V", "checkers.jvm"})
public final class FirUnsupportedSyntheticCallableReferenceChecker
extends FirExpressionChecker<FirCallableReferenceAccess> {
    @NotNull
    public static final FirUnsupportedSyntheticCallableReferenceChecker INSTANCE = new FirUnsupportedSyntheticCallableReferenceChecker();

    private FirUnsupportedSyntheticCallableReferenceChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableReferenceAccess expression2) {
        FirBasedSymbol<?> resolvedSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List<FirElement> it = context2.getContainingElements();
        boolean bl = false;
        if (!(CollectionsKt.last(it) == expression2)) {
            throw new IllegalStateException("Check failed.");
        }
        FirElement parent2 = it.get(CollectionsKt.getLastIndex(it) - 1);
        if (parent2 instanceof FirProperty && ((FirProperty)parent2).getDelegate() == expression2) {
            return;
        }
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference(expression2);
        FirBasedSymbol<Object> firBasedSymbol = resolvedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        if (resolvedSymbol instanceof FirSyntheticPropertySymbol && !(resolvedSymbol instanceof FirJavaOverriddenSyntheticPropertySymbol)) {
            FirHelpersKt.requireFeatureSupport$default(context2, reporter, expression2.getCalleeReference(), LanguageFeature.ReferencesToSyntheticJavaProperties, null, 8, null);
        }
    }
}

