/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.TimestampUtc;

public abstract class PointUtils {
    public static DataPoint projectPoint(DataPoint dataPoint, double d, double d2) {
        double d3 = Math.toRadians(dataPoint.getLatitude().getDouble());
        double d4 = Math.toRadians(dataPoint.getLongitude().getDouble());
        double d5 = Math.asin(Math.sin(d3) * Math.cos(d2) + Math.cos(d3) * Math.sin(d2) * Math.cos(d));
        double d6 = d4 + Math.atan2(Math.sin(d) * Math.sin(d2) * Math.cos(d3), Math.cos(d2) - Math.sin(d3) * Math.sin(d5));
        return new DataPoint(Math.toDegrees(d5), Math.toDegrees(d6));
    }

    public static DataPoint interpolate(DataPoint dataPoint, DataPoint dataPoint2, double d) {
        if (dataPoint == null || dataPoint2 == null) {
            return null;
        }
        DataPoint dataPoint3 = new DataPoint(Latitude.interpolate(dataPoint.getLatitude(), dataPoint2.getLatitude(), d), Longitude.interpolate(dataPoint.getLongitude(), dataPoint2.getLongitude(), d), Altitude.interpolate(dataPoint.getAltitude(), dataPoint2.getAltitude(), d));
        if (dataPoint.hasTimestamp() && dataPoint2.hasTimestamp()) {
            String string = TimestampUtc.interpolate(dataPoint.getTimestamp(), dataPoint2.getTimestamp(), d);
            dataPoint3.setFieldValue(Field.TIMESTAMP, string, false);
        }
        return dataPoint3;
    }

    public static DataPoint interpolate(DataPoint dataPoint, DataPoint dataPoint2, int n, int n2) {
        double d = 1.0 * (double)(n + 1) / (double)(n2 + 1);
        return PointUtils.interpolate(dataPoint, dataPoint2, d);
    }
}

