---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token PKCS8 private key'
---

## Description

The response body contains content that matches the pattern of a PKCS8 private key was identified. PKCS #8 is a standard syntax for storing private key information. A malicious actor with access to this key can encrypt and decrypt all past and future messages. Note that past messages encrypted using this key should be considered compromised, and new messages cannot be considered trusted.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). A PKCS8 key cannot be rotated, a new key must be generated. For more information, please see [openssl.org's documentation on examples of generating keys](https://docs.openssl.org/3.4/man1/openssl-genpkey/#examples).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.167 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
