/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.eventbus;

import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEventPublisher
implements EventPublisher {
    protected final Map<Class<?>, List<EventHandler>> handlers = new HashMap();

    public final <T> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).add(handler);
        } else {
            ArrayList<EventHandler<T>> list = new ArrayList<EventHandler<T>>();
            list.add(handler);
            this.handlers.put(eventType, list);
        }
    }

    public final <T> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
        if (this.handlers.containsKey(eventType)) {
            this.handlers.get(eventType).remove(handler);
        }
    }

    protected <T> void sendAll(Iterable<T> events) {
        for (T event : events) {
            this.send(event);
        }
    }

    protected <T> void send(T event) {
        if (this.handlers.containsKey(Event.class) && event instanceof Event) {
            for (EventHandler handler : this.handlers.get(Event.class)) {
                handler.receive(event);
            }
        }
        if (this.handlers.containsKey(event.getClass())) {
            for (EventHandler handler : this.handlers.get(event.getClass())) {
                handler.receive(event);
            }
        }
    }
}

