/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.internal.di.AnnotationLookup;

public class ObjectDescriptor
implements IObjectDescriptor {
    private final Type desiredType;
    private final Annotation[] annotations;

    public ObjectDescriptor(Type desiredType, Annotation[] allAnnotations) {
        this.desiredType = desiredType;
        this.annotations = allAnnotations == null ? null : this.qualifiers(allAnnotations);
    }

    @Override
    public Type getDesiredType() {
        return this.desiredType;
    }

    @Override
    public boolean hasQualifier(Class<? extends Annotation> clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.annotations == null) {
            return false;
        }
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Annotation[] getQualifiers() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getQualifier(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (this.annotations == null) {
            return null;
        }
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(clazz)) {
                return (T)((Annotation)clazz.cast(annotation));
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.desiredType instanceof Class) {
            buffer.append(((Class)this.desiredType).getSimpleName());
        } else if (this.desiredType != null) {
            buffer.append(this.desiredType);
        }
        if (this.annotations != null) {
            buffer.append('[');
            boolean first = true;
            Annotation[] annotationArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(annotation.toString());
                ++n2;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    private Annotation[] qualifiers(Annotation[] allAnnotations) {
        if (allAnnotations.length == 0) {
            return null;
        }
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        Annotation[] annotationArray = allAnnotations;
        int n = allAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (AnnotationLookup.QUALIFIER.isPresent(annotation.annotationType())) {
                qualifiers.add(annotation);
            }
            ++n2;
        }
        if (qualifiers.isEmpty()) {
            return null;
        }
        Annotation[] result = new Annotation[qualifiers.size()];
        qualifiers.toArray(result);
        return result;
    }
}

