/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPDriverLibraryProvider;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.DataSourceAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.dbeaver.registry.driver.DriverFileInfo;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.driver.DriverLoaderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.VersionUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

public class DriverDescriptorSerializerLegacy
extends DriverDescriptorSerializer {
    public static final String DRIVERS_FILE_NAME = "drivers.xml";
    private static final boolean isDistributed = DBWorkbench.isDistributed();
    private static final boolean isDetachedProcess = DBWorkbench.getPlatform().getApplication().isDetachedProcess();
    private static final Log log = Log.getLog(DriverDescriptorSerializerLegacy.class);

    @Override
    public void serializeDrivers(OutputStream os, List<DataSourceProviderDescriptor> providers) throws IOException {
        XMLBuilder xml = new XMLBuilder(os, GeneralUtils.UTF8_ENCODING);
        xml.setBeautify(true);
        Throwable throwable = null;
        Object var5_6 = null;
        try (XMLBuilder.Element ignored = xml.startElement("drivers");){
            for (DataSourceProviderDescriptor provider : providers) {
                if (provider.isTemporary()) continue;
                List drivers = provider.getDrivers().stream().filter(DriverDescriptor::isModified).collect(Collectors.toList());
                drivers.removeIf(driverDescriptor -> driverDescriptor.getReplacedBy() != null);
                if (drivers.isEmpty()) continue;
                Throwable throwable2 = null;
                Object var11_14 = null;
                try (XMLBuilder.Element ignored2 = xml.startElement("provider");){
                    xml.addAttribute("id", provider.getId());
                    for (DriverDescriptor driver : drivers) {
                        this.serializeDriver(xml, driver);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        xml.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeDriver(XMLBuilder xml, DriverDescriptor driver) throws IOException {
        Map<String, String> pathSubstitutions = this.getPathSubstitutions();
        Throwable throwable = null;
        Object var5_6 = null;
        try (XMLBuilder.Element ignored0 = xml.startElement("driver");){
            XMLBuilder.Element ignored1;
            Iterator iterator;
            Throwable throwable2;
            xml.addAttribute("id", driver.getId());
            if (driver.isDisabled()) {
                xml.addAttribute("disabled", true);
            }
            if (!CommonUtils.isEmpty((String)driver.getCategory())) {
                xml.addAttribute("category", driver.getCategory());
            }
            if (!CommonUtils.isEmpty(driver.getCategories())) {
                xml.addAttribute("categories", String.join((CharSequence)",", driver.getCategories()));
            }
            xml.addAttribute("name", driver.getName());
            if (!CommonUtils.isEmpty((String)driver.getDriverClassName())) {
                xml.addAttribute("class", driver.getDriverClassName());
            }
            if (!CommonUtils.isEmpty((String)driver.getSampleURL())) {
                xml.addAttribute("url", driver.getSampleURL());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultPort())) {
                xml.addAttribute("port", driver.getDefaultPort());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultDatabase())) {
                xml.addAttribute("defaultDatabase", driver.getDefaultDatabase());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultServer())) {
                xml.addAttribute("defaultServer", driver.getDefaultServer());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultUser())) {
                xml.addAttribute("defaultUser", driver.getDefaultUser());
            }
            if (!CommonUtils.isEmpty((String)driver.getDescription())) {
                xml.addAttribute("description", driver.getDescription());
            }
            if (driver.isCustomDriverLoader()) {
                xml.addAttribute("customDriverLoader", driver.isCustomDriverLoader());
            }
            xml.addAttribute("custom", driver.isCustom());
            if (driver.isEmbedded()) {
                xml.addAttribute("embedded", driver.isEmbedded());
            }
            if (driver.isPropagateDriverProperties()) {
                xml.addAttribute("propagateDriverProperties", driver.isPropagateDriverProperties());
            }
            if (driver.isAnonymousAccess()) {
                xml.addAttribute("anonymous", driver.isAnonymousAccess());
            }
            if (driver.isAllowsEmptyPassword()) {
                xml.addAttribute("allowsEmptyPassword", driver.isAllowsEmptyPassword());
            }
            if (!driver.isInstantiable()) {
                xml.addAttribute("instantiable", driver.isInstantiable());
            }
            if (!driver.isSupportsDistributedMode()) {
                xml.addAttribute("supportsDistributedMode", driver.isSupportsDistributedMode());
            }
            if (driver.isThreadSafeDriver() != driver.isOrigThreadSafeDriver()) {
                xml.addAttribute("threadSafe", driver.isThreadSafeDriver());
            }
            LinkedHashMap<DBPDriverLoader, List<Object>> libraries = new LinkedHashMap<DBPDriverLoader, List<Object>>();
            for (DBPDriverLoader dBPDriverLoader : driver.getAllDriverLoaders()) {
                if (dBPDriverLoader == driver.getDefaultDriverLoader()) {
                    libraries.put(dBPDriverLoader, driver.getDriverLibraries());
                    continue;
                }
                List libraryProviders = dBPDriverLoader.getLibraryProviders();
                if (CommonUtils.isEmpty((Collection)libraryProviders)) continue;
                ArrayList additionalLibraries = new ArrayList();
                for (DBPDriverLibraryProvider dlp : libraryProviders) {
                    additionalLibraries.addAll(dlp.getDriverLibraries());
                }
                libraries.put(dBPDriverLoader, additionalLibraries);
            }
            for (Map.Entry entry : libraries.entrySet()) {
                for (DBPDriverLibrary lib : (List)entry.getValue()) {
                    DBPDriverLoader driverLoader = (DBPDriverLoader)entry.getKey();
                    Object object = null;
                    Object var14_31 = null;
                    try (XMLBuilder.Element ignored12 = xml.startElement("library");){
                        void dld;
                        if (!Objects.equals("default", driverLoader.getLoaderId())) {
                            xml.addAttribute("loader", driverLoader.getLoaderId());
                        }
                        xml.addAttribute("type", lib.getType().name());
                        xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, lib.getPath()));
                        xml.addAttribute("custom", lib.isCustom());
                        if (lib.isEmbedded()) {
                            xml.addAttribute("embedded", true);
                        }
                        if (lib.isDisabled()) {
                            xml.addAttribute("disabled", true);
                        }
                        if (!CommonUtils.isEmpty((String)lib.getPreferredVersion())) {
                            xml.addAttribute("version", lib.getPreferredVersion());
                        }
                        if (lib instanceof DriverLibraryMavenArtifact) {
                            DriverLibraryMavenArtifact mavenArtifact = (DriverLibraryMavenArtifact)lib;
                            if (mavenArtifact.isIgnoreDependencies()) {
                                xml.addAttribute("ignore-dependencies", true);
                            }
                            if (mavenArtifact.isLoadOptionalDependencies()) {
                                xml.addAttribute("load-optional-dependencies", true);
                            }
                            if (mavenArtifact.isForcedVersion()) {
                                xml.addAttribute("forced-version", true);
                            }
                        }
                        if (!(driverLoader instanceof DriverLoaderDescriptor)) continue;
                        DriverLoaderDescriptor driverLoaderDescriptor = (DriverLoaderDescriptor)driverLoader;
                        List<DriverFileInfo> files = dld.getResolvedFiles().get(lib);
                        if (files == null) continue;
                        for (DriverFileInfo file : files) {
                            Throwable throwable3 = null;
                            Object var22_41 = null;
                            try (XMLBuilder.Element ignored2 = xml.startElement("file");){
                                if (file.getFile() == null) {
                                    log.warn((Object)("File missing in " + file.getId()));
                                    continue;
                                }
                                xml.addAttribute("id", file.getId());
                                if (!CommonUtils.isEmpty((String)file.getVersion())) {
                                    xml.addAttribute("version", file.getVersion());
                                }
                                String normalizedFilePath = file.getFile().toString();
                                if (isDistributed) {
                                    normalizedFilePath = DriverUtils.getDistributedLibraryPath(file.getFile()).replace('\\', '/');
                                }
                                if (!IOUtils.isFileFromDefaultFS((Path)file.getFile()) && file.getFile().isAbsolute()) {
                                    Path workspaceFolder = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath();
                                    normalizedFilePath = workspaceFolder.relativize(file.getFile()).toString();
                                }
                                xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, normalizedFilePath));
                                if (file.getFileCRC() == 0L) continue;
                                xml.addAttribute("crc", Long.toHexString(file.getFileCRC()));
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (object == null) {
                            object = throwable5;
                        } else if (object != throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                        throw object;
                    }
                }
            }
            for (DBPNativeClientLocation dBPNativeClientLocation : driver.getNativeClientHomes()) {
                throwable2 = null;
                iterator = null;
                try {
                    ignored1 = xml.startElement("clientHome");
                    try {
                        xml.addAttribute("id", dBPNativeClientLocation.getName());
                        xml.addAttribute("path", dBPNativeClientLocation.getPath().getAbsolutePath());
                    }
                    finally {
                        if (ignored1 != null) {
                            ignored1.close();
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                    } else if (throwable2 != throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                    throw throwable2;
                }
            }
            for (Map.Entry entry : driver.getCustomParameters().entrySet()) {
                if (!driver.isCustom() && CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultParameters().get(entry.getKey()))) continue;
                throwable2 = null;
                iterator = null;
                try {
                    ignored1 = xml.startElement("parameter");
                    try {
                        xml.addAttribute("name", (String)entry.getKey());
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (ignored1 != null) {
                            ignored1.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            for (Map.Entry entry : driver.getConnectionProperties().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultConnectionProperties().get(entry.getKey()))) continue;
                throwable2 = null;
                iterator = null;
                try {
                    ignored1 = xml.startElement("property");
                    try {
                        xml.addAttribute("name", (String)entry.getKey());
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (ignored1 != null) {
                            ignored1.close();
                        }
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable2 == null) {
                        throwable2 = throwable8;
                    } else if (throwable2 != throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    public static class DriversParser
    implements SAXListener {
        private final boolean providedDrivers;
        DataSourceProviderDescriptor curProvider;
        DriverDescriptor curDriver;
        DriverLoaderDescriptor curDriverLoader;
        DBPDriverLibrary curLibrary;
        private boolean isLibraryUpgraded = false;
        private static final String PATH_VERSION_OBSOLETE_RELEASE = ":release";

        public DriversParser(boolean provided) {
            this.providedDrivers = provided;
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) {
            switch (localName) {
                case "provider": {
                    this.curProvider = null;
                    this.curDriver = null;
                    String idAttr = attributes.getValue("id");
                    if (CommonUtils.isEmpty((String)idAttr)) {
                        log.warn((Object)"No id for driver provider");
                        return;
                    }
                    this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(idAttr);
                    if (this.curProvider != null || isDetachedProcess) break;
                    log.warn((Object)("Datasource provider '" + idAttr + "' not found. Bad provider description."));
                    break;
                }
                case "driver": {
                    this.curDriver = null;
                    String idAttr = attributes.getValue("id");
                    if (this.curProvider == null) {
                        String providerId = attributes.getValue("provider");
                        if (!CommonUtils.isEmpty((String)providerId)) {
                            this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                            if (this.curProvider == null && !isDetachedProcess) {
                                log.warn((Object)("Datasource provider '" + providerId + "' not found. Bad driver description."));
                            }
                        }
                        if (this.curProvider == null) {
                            if (!isDetachedProcess) {
                                log.warn((Object)("Driver '" + idAttr + "' outside of datasource provider"));
                            }
                            return;
                        }
                    }
                    this.curDriver = this.curProvider.getDriver(idAttr);
                    if (this.curDriver == null) {
                        this.curDriver = new DriverDescriptor(this.curProvider, idAttr);
                        this.curProvider.addDriver(this.curDriver);
                    } else if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                        this.curDriver.resetDriverInstance();
                    }
                    if (this.providedDrivers || this.curProvider.isDriversManageable()) {
                        String category = attributes.getValue("category");
                        if (!CommonUtils.isEmpty((String)category)) {
                            this.curDriver.setCategory(category);
                        }
                        if (this.providedDrivers || this.curDriver.isCustom()) {
                            this.curDriver.setName(CommonUtils.toString((Object)attributes.getValue("name"), (String)this.curDriver.getName()));
                        }
                        this.curDriver.setDescription(CommonUtils.toString((Object)attributes.getValue("description"), (String)this.curDriver.getDescription()));
                        this.curDriver.setDriverClassName(CommonUtils.toString((Object)attributes.getValue("class"), (String)this.curDriver.getDriverClassName()));
                        this.curDriver.setSampleURL(CommonUtils.toString((Object)attributes.getValue("url"), (String)this.curDriver.getSampleURL()));
                        this.curDriver.setDriverDefaultPort(CommonUtils.toString((Object)attributes.getValue("port"), (String)this.curDriver.getDefaultPort()));
                        this.curDriver.setDriverDefaultDatabase(CommonUtils.toString((Object)attributes.getValue("defaultDatabase"), (String)this.curDriver.getDefaultDatabase()));
                        this.curDriver.setDriverDefaultServer(CommonUtils.toString((Object)attributes.getValue("defaultServer"), (String)this.curDriver.getDefaultServer()));
                        this.curDriver.setDriverDefaultUser(CommonUtils.toString((Object)attributes.getValue("defaultUser"), (String)this.curDriver.getDefaultUser()));
                        this.curDriver.setEmbedded(CommonUtils.getBoolean((String)attributes.getValue("embedded"), (boolean)this.curDriver.isEmbedded()));
                        this.curDriver.setPropagateDriverProperties(CommonUtils.getBoolean((String)attributes.getValue("propagateDriverProperties"), (boolean)this.curDriver.isPropagateDriverProperties()));
                        this.curDriver.setAnonymousAccess(CommonUtils.getBoolean((String)attributes.getValue("anonymous"), (boolean)this.curDriver.isAnonymousAccess()));
                        this.curDriver.setAllowsEmptyPassword(CommonUtils.getBoolean((String)attributes.getValue("allowsEmptyPassword"), (boolean)this.curDriver.isAllowsEmptyPassword()));
                        this.curDriver.setInstantiable(CommonUtils.getBoolean((String)attributes.getValue("instantiable"), (boolean)this.curDriver.isInstantiable()));
                        this.curDriver.setThreadSafeDriver(CommonUtils.getBoolean((String)attributes.getValue("threadSafe"), (boolean)this.curDriver.isThreadSafeDriver()));
                    }
                    if (attributes.getValue("customDriverLoader") != null) {
                        this.curDriver.setCustomDriverLoader(CommonUtils.getBoolean((String)attributes.getValue("customDriverLoader"), (boolean)false));
                    }
                    if (attributes.getValue("useURL") != null) {
                        this.curDriver.setUseURL(CommonUtils.getBoolean((String)attributes.getValue("useURL"), (boolean)true));
                    }
                    if (attributes.getValue("supportsDistributedMode") != null) {
                        this.curDriver.setSupportsDistributedMode(CommonUtils.getBoolean((String)attributes.getValue("supportsDistributedMode"), (boolean)true));
                    }
                    this.curDriver.setModified(true);
                    String disabledAttr = attributes.getValue("disabled");
                    if (!CommonUtils.getBoolean((String)disabledAttr)) break;
                    this.curDriver.setDisabled(true);
                    break;
                }
                case "library": {
                    String typeStr;
                    if (this.curDriver == null) {
                        if (!isDetachedProcess) {
                            log.warn((Object)("Library outside of driver (" + attributes.getValue("path") + ")"));
                        }
                        return;
                    }
                    this.isLibraryUpgraded = false;
                    String loaderId = attributes.getValue("loader");
                    DriverLoaderDescriptor driverLoaderDescriptor = this.curDriverLoader = loaderId == null ? null : this.curDriver.preCreateDriverLoader(loaderId);
                    if (this.curDriverLoader == null) {
                        if (loaderId != null) {
                            log.warn((Object)("Driver loader '" + loaderId + "' not found for driver '" + this.curDriver.getFullId() + "'"));
                        }
                        this.curDriverLoader = this.curDriver.getDefaultDriverLoader();
                    }
                    if (loaderId != null) {
                        DataSourceAuthModelDescriptor libProvider = DataSourceProviderRegistry.getInstance().getAuthModel(loaderId);
                        if (libProvider == null) {
                            log.warn((Object)("Auth model '" + loaderId + "' not found"));
                        } else if (!this.curDriverLoader.getLibraryProviders().contains((Object)libProvider)) {
                            this.curDriverLoader.addLibraryProvider((DBPDriverLibraryProvider)libProvider);
                        }
                    }
                    DBPDriverLibrary.FileType type = CommonUtils.isEmpty((String)(typeStr = attributes.getValue("type"))) ? DBPDriverLibrary.FileType.jar : (DBPDriverLibrary.FileType)CommonUtils.valueOf(DBPDriverLibrary.FileType.class, (String)typeStr, (Enum)DBPDriverLibrary.FileType.jar);
                    String path = DriversParser.normalizeLibraryPath(attributes.getValue("path"));
                    if (!CommonUtils.isEmpty((String)path)) {
                        path = DriverDescriptorSerializerLegacy.replacePathVariables(path);
                    }
                    boolean custom = CommonUtils.getBoolean((String)attributes.getValue("custom"), (boolean)true);
                    String version = attributes.getValue("version");
                    DBPDriverLibrary lib = this.curDriver.getDriverLibrary(path);
                    if (!(isDistributed || this.providedDrivers || custom || lib != null)) {
                        return;
                    }
                    if (this.providedDrivers && lib == null && !this.curDriver.getDriverLibraries().isEmpty()) {
                        this.curDriver.disabledAllDefaultLibraries();
                    }
                    if (lib instanceof DriverLibraryMavenArtifact) {
                        DriverLibraryMavenArtifact mvnLibrary = (DriverLibraryMavenArtifact)lib;
                        mvnLibrary.setIgnoreDependencies(CommonUtils.toBoolean((Object)attributes.getValue("ignore-dependencies")));
                        mvnLibrary.setLoadOptionalDependencies(CommonUtils.toBoolean((Object)attributes.getValue("load-optional-dependencies")));
                        mvnLibrary.setForcedVersion(CommonUtils.toBoolean((Object)attributes.getValue("forced-version")));
                    }
                    String disabledAttr = attributes.getValue("disabled");
                    if (lib != null && CommonUtils.getBoolean((String)disabledAttr)) {
                        lib.setDisabled(true);
                    } else if (lib == null) {
                        lib = DriverLibraryAbstract.createFromPath(this.curDriver, type, path, version);
                        if (loaderId == null) {
                            this.curDriver.addDriverLibrary(lib, false);
                        }
                    } else {
                        if (!CommonUtils.isEmpty((String)version) && lib instanceof DriverLibraryMavenArtifact) {
                            DriverLibraryMavenArtifact mavenLib = (DriverLibraryMavenArtifact)lib;
                            String preferredVersion = CommonUtils.toString((Object)lib.getPreferredVersion(), (String)"0");
                            int versionMatch = VersionUtils.compareVersions((String)version, (String)preferredVersion);
                            if (versionMatch > 0 || mavenLib.isForcedVersion()) {
                                mavenLib.setPreferredVersion(version);
                            } else if (versionMatch < 0 && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.drivers.version.update")) {
                                mavenLib.resetVersion();
                                this.isLibraryUpgraded = true;
                            }
                        }
                        if (lib.isDisabled()) {
                            lib.setDisabled(false);
                        }
                    }
                    this.curLibrary = lib;
                    break;
                }
                case "file": {
                    long crc;
                    Path workspaceFolder;
                    String path;
                    if (this.curDriver == null || this.curLibrary == null || this.curDriverLoader == null || this.isLibraryUpgraded || (path = attributes.getValue("path")) == null) break;
                    if (CommonUtils.isEmpty((String)(path = DriverDescriptorSerializerLegacy.replacePathVariables(path)))) {
                        log.warn((Object)"Empty path for library file");
                        break;
                    }
                    Path filePath = Path.of(path, new String[0]);
                    if ((this.curDriver.isCustom() || this.curLibrary.isDownloadable()) && DBWorkbench.getPlatform().getApplication().isMultiuser() && !IOUtils.isFileFromDefaultFS((Path)(workspaceFolder = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath()))) {
                        filePath = workspaceFolder.resolve(path);
                    }
                    DriverFileInfo info = new DriverFileInfo(attributes.getValue("id"), attributes.getValue("version"), this.curLibrary.getType(), filePath, path);
                    String crcString = attributes.getValue("crc");
                    if (!CommonUtils.isEmpty((String)crcString) && (crc = Long.parseLong(crcString, 16)) != 0L) {
                        info.setFileCRC(crc);
                    }
                    this.curDriverLoader.addLibraryFile(this.curLibrary, info);
                    break;
                }
                case "clientHome": {
                    if (this.curDriver == null) break;
                    this.curDriver.addNativeClientLocation((DBPNativeClientLocation)new LocalNativeClientLocation(attributes.getValue("id"), attributes.getValue("path")));
                    break;
                }
                case "parameter": {
                    if (this.curDriver == null) break;
                    String paramName = attributes.getValue("name");
                    String paramValue = attributes.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName) || CommonUtils.isEmpty((String)paramValue)) break;
                    this.curDriver.setDriverParameter(paramName, paramValue, false);
                    break;
                }
                case "property": {
                    if (this.curDriver == null) break;
                    String paramName = attributes.getValue("name");
                    String paramValue = attributes.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName)) break;
                    this.curDriver.setConnectionProperty(paramName, paramValue);
                }
            }
        }

        private static String normalizeLibraryPath(String value) {
            if (((String)value).startsWith("maven:/") && ((String)value).endsWith(PATH_VERSION_OBSOLETE_RELEASE)) {
                value = ((String)value).substring(0, ((String)value).length() - PATH_VERSION_OBSOLETE_RELEASE.length()) + ":RELEASE";
            }
            return value;
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) {
            if (localName.equals("library")) {
                this.curLibrary = null;
            }
        }
    }
}

