/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.File;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.DataSourceRealm;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.catalina.realm.JNDIRealm;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.UserDatabaseRealm;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class MBeanFactory {
    private static final Log log = LogFactory.getLog(MBeanFactory.class);
    protected static final StringManager sm = StringManager.getManager(MBeanFactory.class);
    private static final MBeanServer mserver = MBeanUtils.createServer();
    private Object container;

    public void setContainer(Object object) {
        this.container = object;
    }

    private String getPathStr(String string) {
        if (string == null || string.equals("/")) {
            return "";
        }
        return string;
    }

    private Container getParentContainerFromParent(ObjectName objectName) throws Exception {
        String string = objectName.getKeyProperty("type");
        String string2 = objectName.getKeyProperty("j2eeType");
        Service service = this.getService(objectName);
        StandardEngine standardEngine = (StandardEngine)service.getContainer();
        if (string2 != null && string2.equals("WebModule")) {
            String string3 = objectName.getKeyProperty("name");
            string3 = string3.substring(2);
            int n = string3.indexOf(47);
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n);
            Container container = standardEngine.findChild(string4);
            String string6 = this.getPathStr(string5);
            return container.findChild(string6);
        }
        if (string != null) {
            if (string.equals("Engine")) {
                return standardEngine;
            }
            if (string.equals("Host")) {
                String string7 = objectName.getKeyProperty("host");
                return standardEngine.findChild(string7);
            }
        }
        return null;
    }

    private Container getParentContainerFromChild(ObjectName objectName) throws Exception {
        String string = objectName.getKeyProperty("host");
        String string2 = objectName.getKeyProperty("path");
        Service service = this.getService(objectName);
        Engine engine = service.getContainer();
        if (string == null) {
            return engine;
        }
        if (string2 == null) {
            return engine.findChild(string);
        }
        Container container = engine.findChild(string);
        string2 = this.getPathStr(string2);
        return container.findChild(string2);
    }

    private Service getService(ObjectName objectName) throws Exception {
        if (this.container instanceof Service) {
            return (Service)this.container;
        }
        LifecycleMBeanBase lifecycleMBeanBase = null;
        String string = objectName.getDomain();
        if (this.container instanceof Server) {
            Service service;
            Service[] serviceArray;
            Service[] serviceArray2 = serviceArray = ((Server)this.container).findServices();
            int n = serviceArray2.length;
            for (int i = 0; i < n && !string.equals((lifecycleMBeanBase = (StandardService)(service = serviceArray2[i])).getObjectName().getDomain()); ++i) {
            }
        }
        if (lifecycleMBeanBase == null || !lifecycleMBeanBase.getObjectName().getDomain().equals(string)) {
            throw new Exception(sm.getString("mBeanFactory.noService", new Object[]{string}));
        }
        return lifecycleMBeanBase;
    }

    public String createAjpConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, true, false);
    }

    public String createDataSourceRealm(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        DataSourceRealm dataSourceRealm = new DataSourceRealm();
        dataSourceRealm.setDataSourceName(string2);
        dataSourceRealm.setRoleNameCol(string3);
        dataSourceRealm.setUserCredCol(string4);
        dataSourceRealm.setUserNameCol(string5);
        dataSourceRealm.setUserRoleTable(string6);
        dataSourceRealm.setUserTable(string7);
        return this.addRealmToParent(string, dataSourceRealm);
    }

    private String addRealmToParent(String string, Realm realm) throws Exception {
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromParent(objectName);
        if (container == null) {
            throw new IllegalArgumentException(sm.getString("mBeanFactory.noParent", new Object[]{string}));
        }
        container.setRealm(realm);
        ObjectName objectName2 = null;
        if (realm instanceof JmxEnabled) {
            objectName2 = ((JmxEnabled)((Object)realm)).getObjectName();
        }
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createHttpConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, false, false);
    }

    private String createConnector(String string, String string2, int n, boolean bl, boolean bl2) throws Exception {
        String string3 = bl ? "AJP/1.3" : "HTTP/1.1";
        Connector connector = new Connector(string3);
        if (string2 != null && !string2.isEmpty()) {
            connector.setProperty("address", string2);
        }
        connector.setPort(n);
        connector.setSecure(bl2);
        connector.setScheme(bl2 ? "https" : "http");
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        service.addConnector(connector);
        ObjectName objectName2 = connector.getObjectName();
        return objectName2.toString();
    }

    public String createHttpsConnector(String string, String string2, int n) throws Exception {
        return this.createConnector(string, string2, n, false, true);
    }

    @Deprecated
    public String createJDBCRealm(String string, String string2, String string3, String string4, String string5) throws Exception {
        JDBCRealm jDBCRealm = new JDBCRealm();
        jDBCRealm.setDriverName(string2);
        jDBCRealm.setConnectionName(string3);
        jDBCRealm.setConnectionPassword(string4);
        jDBCRealm.setConnectionURL(string5);
        return this.addRealmToParent(string, jDBCRealm);
    }

    public String createJNDIRealm(String string) throws Exception {
        JNDIRealm jNDIRealm = new JNDIRealm();
        return this.addRealmToParent(string, jNDIRealm);
    }

    public String createMemoryRealm(String string) throws Exception {
        MemoryRealm memoryRealm = new MemoryRealm();
        return this.addRealmToParent(string, memoryRealm);
    }

    public String createStandardContext(String string, String string2, String string3) throws Exception {
        return this.createStandardContext(string, string2, string3, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createStandardContext(String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        StandardContext standardContext;
        block5: {
            ObjectName objectName;
            block3: {
                String string4;
                block4: {
                    standardContext = new StandardContext();
                    string2 = this.getPathStr(string2);
                    standardContext.setPath(string2);
                    standardContext.setDocBase(string3);
                    standardContext.setXmlValidation(bl);
                    standardContext.setXmlNamespaceAware(bl2);
                    ContextConfig contextConfig = new ContextConfig();
                    standardContext.addLifecycleListener(contextConfig);
                    objectName = new ObjectName(string);
                    ObjectName objectName2 = new ObjectName(objectName.getDomain() + ":type=Deployer,host=" + objectName.getKeyProperty("host"));
                    if (!mserver.isRegistered(objectName2)) break block3;
                    string4 = standardContext.getName();
                    Boolean bl3 = (Boolean)mserver.invoke(objectName2, "tryAddServiced", new Object[]{string4}, new String[]{"java.lang.String"});
                    if (!bl3.booleanValue()) break block4;
                    try {
                        String string5 = (String)mserver.getAttribute(objectName2, "configBaseName");
                        String string6 = standardContext.getBaseName();
                        File file = new File(new File(string5), string6 + ".xml");
                        if (file.isFile()) {
                            standardContext.setConfigFile(file.toURI().toURL());
                        }
                        mserver.invoke(objectName2, "manageApp", new Object[]{standardContext}, new String[]{"org.apache.catalina.Context"});
                    }
                    catch (Throwable throwable) {
                        mserver.invoke(objectName2, "removeServiced", new Object[]{string4}, new String[]{"java.lang.String"});
                        throw throwable;
                    }
                    mserver.invoke(objectName2, "removeServiced", new Object[]{string4}, new String[]{"java.lang.String"});
                    break block5;
                }
                throw new IllegalStateException(sm.getString("mBeanFactory.contextCreate.addServicedFail", new Object[]{string4}));
            }
            log.warn((Object)sm.getString("mBeanFactory.noDeployer", new Object[]{objectName.getKeyProperty("host")}));
            Service service = this.getService(objectName);
            Engine engine = service.getContainer();
            Host host = (Host)engine.findChild(objectName.getKeyProperty("host"));
            host.addChild(standardContext);
        }
        return standardContext.getObjectName().toString();
    }

    public String createStandardHost(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        StandardHost standardHost = new StandardHost();
        standardHost.setName(string2);
        standardHost.setAppBase(string3);
        standardHost.setAutoDeploy(bl);
        standardHost.setDeployOnStartup(bl2);
        standardHost.setDeployXML(bl3);
        standardHost.setUnpackWARs(bl4);
        HostConfig hostConfig = new HostConfig();
        standardHost.addLifecycleListener(hostConfig);
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        Engine engine = service.getContainer();
        engine.addChild(standardHost);
        return standardHost.getObjectName().toString();
    }

    public String createStandardServiceEngine(String string, String string2, String string3) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception(sm.getString("mBeanFactory.notServer"));
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setDomain(string);
        standardEngine.setName(string);
        standardEngine.setDefaultHost(string2);
        StandardService standardService = new StandardService();
        standardService.setContainer(standardEngine);
        standardService.setName(string);
        ((Server)this.container).addService(standardService);
        return standardEngine.getObjectName().toString();
    }

    public String createStandardManager(String string) throws Exception {
        StandardManager standardManager = new StandardManager();
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromParent(objectName);
        if (!(container instanceof Context)) {
            throw new Exception(sm.getString("mBeanFactory.managerContext"));
        }
        ((Context)container).setManager(standardManager);
        ObjectName objectName2 = standardManager.getObjectName();
        if (objectName2 != null) {
            return objectName2.toString();
        }
        return null;
    }

    public String createUserDatabaseRealm(String string, String string2) throws Exception {
        UserDatabaseRealm userDatabaseRealm = new UserDatabaseRealm();
        userDatabaseRealm.setResourceName(string2);
        return this.addRealmToParent(string, userDatabaseRealm);
    }

    public String createValve(String string, String string2) throws Exception {
        ObjectName objectName = new ObjectName(string2);
        Container container = this.getParentContainerFromParent(objectName);
        if (container == null) {
            throw new IllegalArgumentException(sm.getString("mBeanFactory.noParent", new Object[]{string2}));
        }
        Valve valve = (Valve)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        container.getPipeline().addValve(valve);
        if (valve instanceof JmxEnabled) {
            return ((JmxEnabled)((Object)valve)).getObjectName().toString();
        }
        return null;
    }

    public String createWebappLoader(String string) throws Exception {
        WebappLoader webappLoader = new WebappLoader();
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromParent(objectName);
        if (container instanceof Context) {
            ((Context)container).setLoader(webappLoader);
        }
        return webappLoader.getObjectName().toString();
    }

    public void removeConnector(String string) throws Exception {
        Connector[] connectorArray;
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        String string2 = objectName.getKeyProperty("port");
        String string3 = objectName.getKeyProperty("address");
        if (string3 != null) {
            string3 = ObjectName.unquote(string3);
        }
        for (Connector connector : connectorArray = service.findConnectors()) {
            String string4 = null;
            Object object = connector.getProperty("address");
            if (object != null) {
                string4 = ((InetAddress)object).getHostAddress();
            }
            String string5 = "" + connector.getPortWithOffset();
            if (string3 == null) {
                if (string4 != null || !string2.equals(string5)) continue;
                service.removeConnector(connector);
                connector.destroy();
                break;
            }
            if (!string3.equals(string4) || !string2.equals(string5)) continue;
            service.removeConnector(connector);
            connector.destroy();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(String string) throws Exception {
        block7: {
            String string2;
            String string3;
            Engine engine;
            block5: {
                block6: {
                    ObjectName objectName = new ObjectName(string);
                    String string4 = objectName.getDomain();
                    StandardService standardService = (StandardService)this.getService(objectName);
                    engine = standardService.getContainer();
                    String string5 = objectName.getKeyProperty("name");
                    string5 = string5.substring(2);
                    int n = string5.indexOf(47);
                    string3 = string5.substring(0, n);
                    String string6 = string5.substring(n);
                    ObjectName objectName2 = new ObjectName(string4 + ":type=Deployer,host=" + string3);
                    string2 = this.getPathStr(string6);
                    if (!mserver.isRegistered(objectName2)) break block5;
                    Boolean bl = (Boolean)mserver.invoke(objectName2, "tryAddServiced", new Object[]{string2}, new String[]{"java.lang.String"});
                    if (!bl.booleanValue()) break block6;
                    try {
                        mserver.invoke(objectName2, "unmanageApp", new Object[]{string2}, new String[]{"java.lang.String"});
                    }
                    catch (Throwable throwable) {
                        mserver.invoke(objectName2, "removeServiced", new Object[]{string2}, new String[]{"java.lang.String"});
                        throw throwable;
                    }
                    mserver.invoke(objectName2, "removeServiced", new Object[]{string2}, new String[]{"java.lang.String"});
                    break block7;
                }
                throw new IllegalStateException(sm.getString("mBeanFactory.removeContext.addServicedFail", new Object[]{string2}));
            }
            log.warn((Object)sm.getString("mBeanFactory.noDeployer", new Object[]{string3}));
            Host host = (Host)engine.findChild(string3);
            Context context = (Context)host.findChild(string2);
            host.removeChild(context);
            if (context instanceof StandardContext) {
                try {
                    context.destroy();
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("mBeanFactory.contextDestroyError"), (Throwable)exception);
                }
            }
        }
    }

    public void removeHost(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        String string2 = objectName.getKeyProperty("host");
        Service service = this.getService(objectName);
        Engine engine = service.getContainer();
        Host host = (Host)engine.findChild(string2);
        if (host != null) {
            engine.removeChild(host);
        }
    }

    public void removeLoader(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromChild(objectName);
        if (container instanceof Context) {
            ((Context)container).setLoader(null);
        }
    }

    public void removeManager(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromChild(objectName);
        if (container instanceof Context) {
            ((Context)container).setManager(null);
        }
    }

    public void removeRealm(String string) throws Exception {
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromChild(objectName);
        container.setRealm(null);
    }

    public void removeService(String string) throws Exception {
        if (!(this.container instanceof Server)) {
            throw new Exception(sm.getString("mBeanFactory.notServer"));
        }
        ObjectName objectName = new ObjectName(string);
        Service service = this.getService(objectName);
        ((Server)this.container).removeService(service);
    }

    public void removeValve(String string) throws Exception {
        Valve[] valveArray;
        ObjectName objectName = new ObjectName(string);
        Container container = this.getParentContainerFromChild(objectName);
        for (Valve valve : valveArray = container.getPipeline().getValves()) {
            ObjectName objectName2 = ((JmxEnabled)((Object)valve)).getObjectName();
            if (!objectName2.equals(objectName)) continue;
            container.getPipeline().removeValve(valve);
        }
    }
}

