/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocol;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.protocolPB.QJournalProtocolPB;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.thirdparty.protobuf.RpcController;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class QJournalProtocolTranslatorPB
implements ProtocolMetaInterface,
QJournalProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final QJournalProtocolPB rpcProxy;

    public QJournalProtocolTranslatorPB(QJournalProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public boolean isFormatted(String journalId, String nameServiceId) throws IOException {
        QJournalProtocolProtos.IsFormattedRequestProto.Builder req = QJournalProtocolProtos.IsFormattedRequestProto.newBuilder().setJid(this.convertJournalId(journalId));
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        QJournalProtocolProtos.IsFormattedResponseProto resp = (QJournalProtocolProtos.IsFormattedResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.isFormatted(NULL_CONTROLLER, req.build()));
        return resp.getIsFormatted();
    }

    @Override
    public QJournalProtocolProtos.GetJournalStateResponseProto getJournalState(String jid, String nameServiceId) throws IOException {
        QJournalProtocolProtos.GetJournalStateRequestProto.Builder req = QJournalProtocolProtos.GetJournalStateRequestProto.newBuilder().setJid(this.convertJournalId(jid));
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        return (QJournalProtocolProtos.GetJournalStateResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getJournalState(NULL_CONTROLLER, req.build()));
    }

    private QJournalProtocolProtos.JournalIdProto convertJournalId(String jid) {
        return QJournalProtocolProtos.JournalIdProto.newBuilder().setIdentifier(jid).build();
    }

    @Override
    public void format(String jid, String nameServiceId, NamespaceInfo nsInfo, boolean force) throws IOException {
        QJournalProtocolProtos.FormatRequestProto.Builder req = QJournalProtocolProtos.FormatRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setNsInfo(PBHelper.convert(nsInfo)).setForce(force);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.format(NULL_CONTROLLER, req.build()));
    }

    @Override
    public QJournalProtocolProtos.NewEpochResponseProto newEpoch(String jid, String nameServiceId, NamespaceInfo nsInfo, long epoch) throws IOException {
        QJournalProtocolProtos.NewEpochRequestProto.Builder req = QJournalProtocolProtos.NewEpochRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setNsInfo(PBHelper.convert(nsInfo)).setEpoch(epoch);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        return (QJournalProtocolProtos.NewEpochResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.newEpoch(NULL_CONTROLLER, req.build()));
    }

    @Override
    public void journal(RequestInfo reqInfo, long segmentTxId, long firstTxnId, int numTxns, byte[] records) throws IOException {
        QJournalProtocolProtos.JournalRequestProto req = QJournalProtocolProtos.JournalRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setSegmentTxnId(segmentTxId).setFirstTxnId(firstTxnId).setNumTxns(numTxns).setRecords(PBHelperClient.getByteString((byte[])records)).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.journal(NULL_CONTROLLER, req));
    }

    @Override
    public void heartbeat(RequestInfo reqInfo) throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.heartbeat(NULL_CONTROLLER, QJournalProtocolProtos.HeartbeatRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).build()));
    }

    private QJournalProtocolProtos.RequestInfoProto convert(RequestInfo reqInfo) {
        QJournalProtocolProtos.RequestInfoProto.Builder builder = QJournalProtocolProtos.RequestInfoProto.newBuilder().setJournalId(this.convertJournalId(reqInfo.getJournalId())).setEpoch(reqInfo.getEpoch()).setIpcSerialNumber(reqInfo.getIpcSerialNumber());
        if (reqInfo.hasCommittedTxId()) {
            builder.setCommittedTxId(reqInfo.getCommittedTxId());
        }
        if (reqInfo.getNameServiceId() != null) {
            builder.setNameServiceId(reqInfo.getNameServiceId());
        }
        return builder.build();
    }

    @Override
    public void startLogSegment(RequestInfo reqInfo, long txid, int layoutVersion) throws IOException {
        QJournalProtocolProtos.StartLogSegmentRequestProto req = QJournalProtocolProtos.StartLogSegmentRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setTxid(txid).setLayoutVersion(layoutVersion).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.startLogSegment(NULL_CONTROLLER, req));
    }

    @Override
    public void finalizeLogSegment(RequestInfo reqInfo, long startTxId, long endTxId) throws IOException {
        QJournalProtocolProtos.FinalizeLogSegmentRequestProto req = QJournalProtocolProtos.FinalizeLogSegmentRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setStartTxId(startTxId).setEndTxId(endTxId).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.finalizeLogSegment(NULL_CONTROLLER, req));
    }

    @Override
    public void purgeLogsOlderThan(RequestInfo reqInfo, long minTxIdToKeep) throws IOException {
        QJournalProtocolProtos.PurgeLogsRequestProto req = QJournalProtocolProtos.PurgeLogsRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setMinTxIdToKeep(minTxIdToKeep).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.purgeLogs(NULL_CONTROLLER, req));
    }

    @Override
    public QJournalProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(String jid, String nameServiceId, long sinceTxId, boolean inProgressOk) throws IOException {
        QJournalProtocolProtos.GetEditLogManifestRequestProto.Builder req = QJournalProtocolProtos.GetEditLogManifestRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setSinceTxId(sinceTxId).setInProgressOk(inProgressOk);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        return (QJournalProtocolProtos.GetEditLogManifestResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getEditLogManifest(NULL_CONTROLLER, req.build()));
    }

    @Override
    public QJournalProtocolProtos.GetJournaledEditsResponseProto getJournaledEdits(String jid, String nameServiceId, long sinceTxId, int maxTxns) throws IOException {
        QJournalProtocolProtos.GetJournaledEditsRequestProto.Builder req = QJournalProtocolProtos.GetJournaledEditsRequestProto.newBuilder().setJid(this.convertJournalId(jid)).setSinceTxId(sinceTxId).setMaxTxns(maxTxns);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        return (QJournalProtocolProtos.GetJournaledEditsResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getJournaledEdits(NULL_CONTROLLER, req.build()));
    }

    @Override
    public QJournalProtocolProtos.PrepareRecoveryResponseProto prepareRecovery(RequestInfo reqInfo, long segmentTxId) throws IOException {
        return (QJournalProtocolProtos.PrepareRecoveryResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.prepareRecovery(NULL_CONTROLLER, QJournalProtocolProtos.PrepareRecoveryRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setSegmentTxId(segmentTxId).build()));
    }

    @Override
    public void acceptRecovery(RequestInfo reqInfo, QJournalProtocolProtos.SegmentStateProto stateToAccept, URL fromUrl) throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.acceptRecovery(NULL_CONTROLLER, QJournalProtocolProtos.AcceptRecoveryRequestProto.newBuilder().setReqInfo(this.convert(reqInfo)).setStateToAccept(stateToAccept).setFromURL(fromUrl.toExternalForm()).build()));
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, QJournalProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(QJournalProtocolPB.class), (String)methodName);
    }

    @Override
    public void doPreUpgrade(String jid) throws IOException {
        QJournalProtocolProtos.DoPreUpgradeRequestProto.Builder req = QJournalProtocolProtos.DoPreUpgradeRequestProto.newBuilder().setJid(this.convertJournalId(jid));
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.doPreUpgrade(NULL_CONTROLLER, req.build()));
    }

    @Override
    public void doUpgrade(String journalId, StorageInfo sInfo) throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.doUpgrade(NULL_CONTROLLER, QJournalProtocolProtos.DoUpgradeRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setSInfo(PBHelper.convert(sInfo)).build()));
    }

    @Override
    public void doFinalize(String jid, String nameServiceId) throws IOException {
        QJournalProtocolProtos.DoFinalizeRequestProto.Builder req = QJournalProtocolProtos.DoFinalizeRequestProto.newBuilder().setJid(this.convertJournalId(jid));
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.doFinalize(NULL_CONTROLLER, req.build()));
    }

    @Override
    public Boolean canRollBack(String journalId, String nameServiceId, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        QJournalProtocolProtos.CanRollBackRequestProto.Builder req = QJournalProtocolProtos.CanRollBackRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setStorage(PBHelper.convert(storage)).setPrevStorage(PBHelper.convert(prevStorage)).setTargetLayoutVersion(targetLayoutVersion);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        QJournalProtocolProtos.CanRollBackResponseProto response = (QJournalProtocolProtos.CanRollBackResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.canRollBack(NULL_CONTROLLER, req.build()));
        return response.getCanRollBack();
    }

    @Override
    public void doRollback(String journalId, String nameServiceId) throws IOException {
        QJournalProtocolProtos.DoRollbackRequestProto.Builder req = QJournalProtocolProtos.DoRollbackRequestProto.newBuilder().setJid(this.convertJournalId(journalId));
        if (nameServiceId != null) {
            req.setNameserviceId(nameServiceId);
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.doRollback(NULL_CONTROLLER, req.build()));
    }

    @Override
    public void discardSegments(String journalId, String nameServiceId, long startTxId) throws IOException {
        QJournalProtocolProtos.DiscardSegmentsRequestProto.Builder req = QJournalProtocolProtos.DiscardSegmentsRequestProto.newBuilder().setJid(this.convertJournalId(journalId)).setStartTxId(startTxId);
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.discardSegments(NULL_CONTROLLER, req.build()));
    }

    @Override
    public Long getJournalCTime(String journalId, String nameServiceId) throws IOException {
        QJournalProtocolProtos.GetJournalCTimeRequestProto.Builder req = QJournalProtocolProtos.GetJournalCTimeRequestProto.newBuilder().setJid(this.convertJournalId(journalId));
        if (nameServiceId != null) {
            req.setNameServiceId(nameServiceId);
        }
        QJournalProtocolProtos.GetJournalCTimeResponseProto response = (QJournalProtocolProtos.GetJournalCTimeResponseProto)ShadedProtobufHelper.ipc(() -> this.rpcProxy.getJournalCTime(NULL_CONTROLLER, req.build()));
        return response.getResultCTime();
    }
}

