/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.snapshot.SnapshotShardsStats;
import org.opensearch.client.opensearch.snapshot.SnapshotShardsStatus;
import org.opensearch.client.opensearch.snapshot.SnapshotStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SnapshotIndexStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SnapshotIndexStats> {
    @Nonnull
    private final Map<String, SnapshotShardsStatus> shards;
    @Nullable
    private final SnapshotShardsStats shardsStats;
    @Nullable
    private final SnapshotStats stats;
    public static final JsonpDeserializer<SnapshotIndexStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotIndexStats::setupSnapshotIndexStatsDeserializer);

    private SnapshotIndexStats(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.shardsStats = builder.shardsStats;
        this.stats = builder.stats;
    }

    public static SnapshotIndexStats of(Function<Builder, ObjectBuilder<SnapshotIndexStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, SnapshotShardsStatus> shards() {
        return this.shards;
    }

    @Nullable
    public final SnapshotShardsStats shardsStats() {
        return this.shardsStats;
    }

    @Nullable
    public final SnapshotStats stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, SnapshotShardsStatus> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.shardsStats != null) {
            generator.writeKey("shards_stats");
            this.shardsStats.serialize(generator, mapper);
        }
        if (this.stats != null) {
            generator.writeKey("stats");
            this.stats.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSnapshotIndexStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(SnapshotShardsStatus._DESERIALIZER), "shards");
        op.add(Builder::shardsStats, SnapshotShardsStats._DESERIALIZER, "shards_stats");
        op.add(Builder::stats, SnapshotStats._DESERIALIZER, "stats");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Objects.hashCode(this.shardsStats);
        result = 31 * result + Objects.hashCode(this.stats);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIndexStats other = (SnapshotIndexStats)o;
        return Objects.equals(this.shards, other.shards) && Objects.equals(this.shardsStats, other.shardsStats) && Objects.equals(this.stats, other.stats);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SnapshotIndexStats> {
        @Nullable
        private Map<String, SnapshotShardsStatus> shards;
        @Nullable
        private SnapshotShardsStats shardsStats;
        @Nullable
        private SnapshotStats stats;

        public Builder() {
        }

        private Builder(SnapshotIndexStats o) {
            this.shards = Builder._mapCopy(o.shards);
            this.shardsStats = o.shardsStats;
            this.stats = o.stats;
        }

        private Builder(Builder o) {
            this.shards = Builder._mapCopy(o.shards);
            this.shardsStats = o.shardsStats;
            this.stats = o.stats;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder shards(Map<String, SnapshotShardsStatus> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, SnapshotShardsStatus value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, Function<SnapshotShardsStatus.Builder, ObjectBuilder<SnapshotShardsStatus>> fn) {
            return this.shards(key, fn.apply(new SnapshotShardsStatus.Builder()).build());
        }

        @Nonnull
        public final Builder shardsStats(@Nullable SnapshotShardsStats value) {
            this.shardsStats = value;
            return this;
        }

        @Nonnull
        public final Builder shardsStats(Function<SnapshotShardsStats.Builder, ObjectBuilder<SnapshotShardsStats>> fn) {
            return this.shardsStats(fn.apply(new SnapshotShardsStats.Builder()).build());
        }

        @Nonnull
        public final Builder stats(@Nullable SnapshotStats value) {
            this.stats = value;
            return this;
        }

        @Nonnull
        public final Builder stats(Function<SnapshotStats.Builder, ObjectBuilder<SnapshotStats>> fn) {
            return this.stats(fn.apply(new SnapshotStats.Builder()).build());
        }

        @Override
        @Nonnull
        public SnapshotIndexStats build() {
            this._checkSingleUse();
            return new SnapshotIndexStats(this);
        }
    }
}

