/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.recovery.FileDetails;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RecoveryFiles
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RecoveryFiles> {
    @Nonnull
    private final List<FileDetails> details;
    @Nonnull
    private final String percent;
    private final long recovered;
    private final long reused;
    private final long total;
    public static final JsonpDeserializer<RecoveryFiles> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryFiles::setupRecoveryFilesDeserializer);

    private RecoveryFiles(Builder builder) {
        this.details = ApiTypeHelper.unmodifiable(builder.details);
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, this, "recovered");
        this.reused = ApiTypeHelper.requireNonNull(builder.reused, this, "reused");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static RecoveryFiles of(Function<Builder, ObjectBuilder<RecoveryFiles>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<FileDetails> details() {
        return this.details;
    }

    @Nonnull
    public final String percent() {
        return this.percent;
    }

    public final long recovered() {
        return this.recovered;
    }

    public final long reused() {
        return this.reused;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (FileDetails item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("reused");
        generator.write(this.reused);
        generator.writeKey("total");
        generator.write(this.total);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRecoveryFilesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(FileDetails._DESERIALIZER), "details");
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered");
        op.add(Builder::reused, JsonpDeserializer.longDeserializer(), "reused");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.details);
        result = 31 * result + this.percent.hashCode();
        result = 31 * result + Long.hashCode(this.recovered);
        result = 31 * result + Long.hashCode(this.reused);
        result = 31 * result + Long.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveryFiles other = (RecoveryFiles)o;
        return Objects.equals(this.details, other.details) && this.percent.equals(other.percent) && this.recovered == other.recovered && this.reused == other.reused && this.total == other.total;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RecoveryFiles> {
        @Nullable
        private List<FileDetails> details;
        private String percent;
        private Long recovered;
        private Long reused;
        private Long total;

        public Builder() {
        }

        private Builder(RecoveryFiles o) {
            this.details = Builder._listCopy(o.details);
            this.percent = o.percent;
            this.recovered = o.recovered;
            this.reused = o.reused;
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.details = Builder._listCopy(o.details);
            this.percent = o.percent;
            this.recovered = o.recovered;
            this.reused = o.reused;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder details(List<FileDetails> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        @Nonnull
        public final Builder details(FileDetails value, FileDetails ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        @Nonnull
        public final Builder details(Function<FileDetails.Builder, ObjectBuilder<FileDetails>> fn) {
            return this.details(fn.apply(new FileDetails.Builder()).build(), new FileDetails[0]);
        }

        @Nonnull
        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        @Nonnull
        public final Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        @Nonnull
        public final Builder reused(long value) {
            this.reused = value;
            return this;
        }

        @Nonnull
        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        @Nonnull
        public RecoveryFiles build() {
            this._checkSingleUse();
            return new RecoveryFiles(this);
        }
    }
}

