/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.UploadListener;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.InternalEngine;
import org.opensearch.index.remote.RemoteSegmentTransferTracker;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.ReleasableRetryableRefreshListener;
import org.opensearch.index.shard.RemoteStoreUploader;
import org.opensearch.index.shard.RemoteStoreUploaderService;
import org.opensearch.index.shard.SegmentUploadFailedException;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;

public final class RemoteStoreRefreshListener
extends ReleasableRetryableRefreshListener {
    private final Logger logger;
    private static final int REMOTE_REFRESH_RETRY_BASE_INTERVAL_MILLIS = 1000;
    private static final int REMOTE_REFRESH_RETRY_MAX_INTERVAL_MILLIS = 10000;
    private static final int INVALID_PRIMARY_TERM = -1;
    private static final BackoffPolicy EXPONENTIAL_BACKOFF_POLICY = BackoffPolicy.exponentialEqualJitterBackoff(1000L, 10000L);
    public static final Set<String> EXCLUDE_FILES = Set.of("write.lock");
    private final IndexShard indexShard;
    private final Directory storeDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final RemoteSegmentTransferTracker segmentTracker;
    private final Map<String, String> localSegmentChecksumMap;
    private volatile long primaryTerm;
    private volatile Iterator<TimeValue> backoffDelayIterator;
    private final SegmentReplicationCheckpointPublisher checkpointPublisher;
    private final RemoteStoreSettings remoteStoreSettings;
    private final RemoteStoreUploader remoteStoreUploader;

    public RemoteStoreRefreshListener(IndexShard indexShard, SegmentReplicationCheckpointPublisher checkpointPublisher, RemoteSegmentTransferTracker segmentTracker, RemoteStoreSettings remoteStoreSettings) {
        super(indexShard.getThreadPool());
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
        this.indexShard = indexShard;
        this.storeDirectory = indexShard.store().directory();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)((FilterDirectory)((FilterDirectory)indexShard.remoteStore().directory()).getDelegate()).getDelegate();
        this.remoteStoreUploader = new RemoteStoreUploaderService(indexShard, this.storeDirectory, this.remoteDirectory);
        this.localSegmentChecksumMap = new HashMap<String, String>();
        RemoteSegmentMetadata remoteSegmentMetadata = null;
        if (indexShard.routingEntry().primary()) {
            try {
                remoteSegmentMetadata = this.remoteDirectory.init();
            }
            catch (IOException e) {
                this.logger.error("Exception while initialising RemoteSegmentStoreDirectory", (Throwable)e);
            }
        }
        this.primaryTerm = remoteSegmentMetadata != null ? remoteSegmentMetadata.getPrimaryTerm() : -1L;
        this.segmentTracker = segmentTracker;
        this.resetBackOffDelayIterator();
        this.checkpointPublisher = checkpointPublisher;
        this.remoteStoreSettings = remoteStoreSettings;
    }

    public void beforeRefresh() throws IOException {
    }

    @Override
    protected void runAfterRefreshExactlyOnce(boolean didRefresh) {
        if (this.shouldSync(didRefresh, true) && this.isReadyForUpload()) {
            try {
                this.segmentTracker.updateLocalRefreshTimeAndSeqNo();
                try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();){
                    Collection localSegmentsPostRefresh = segmentInfosGatedCloseable.get().files(true);
                    this.updateLocalSizeMapAndTracker(localSegmentsPostRefresh);
                }
            }
            catch (Throwable t) {
                this.logger.error("Exception in runAfterRefreshExactlyOnce() method", t);
            }
        }
    }

    @Override
    protected boolean performAfterRefreshWithPermit(boolean didRefresh) {
        boolean successful = this.shouldSync(didRefresh, false) ? this.syncSegments() : true;
        return successful;
    }

    private boolean shouldSync(boolean didRefresh, boolean skipPrimaryTermCheck) {
        boolean shouldSync;
        if (this.shardClosed()) {
            this.logger.info("Shard is already closed. Not attempting sync to remote store");
            return false;
        }
        boolean bl = shouldSync = didRefresh || this.remoteDirectory.getSegmentsUploadedToRemoteStore().isEmpty() || this.isRefreshAfterCommitSafe() || !this.isRemoteSegmentStoreInSync();
        if (shouldSync || skipPrimaryTermCheck) {
            return shouldSync;
        }
        return this.primaryTerm != this.indexShard.getOperationPrimaryTerm();
    }

    boolean isRemoteSegmentStoreInSync() {
        boolean bl;
        block8: {
            GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();
            try {
                bl = segmentInfosGatedCloseable.get().files(true).stream().allMatch(this::skipUpload);
                if (segmentInfosGatedCloseable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (segmentInfosGatedCloseable != null) {
                        try {
                            segmentInfosGatedCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    this.logger.error("Throwable thrown during isRemoteSegmentStoreInSync", throwable3);
                    return false;
                }
            }
            segmentInfosGatedCloseable.close();
        }
        return bl;
    }

    private boolean syncSegments() {
        if (!this.isReadyForUpload()) {
            return this.indexShard.state() != IndexShardState.STARTED || !(this.indexShard.getEngine() instanceof InternalEngine);
        }
        this.beforeSegmentsSync();
        final long refreshTimeMs = this.segmentTracker.getLocalRefreshTimeMs();
        final long refreshClockTimeMs = this.segmentTracker.getLocalRefreshClockTimeMs();
        final long refreshSeqNo = this.segmentTracker.getLocalRefreshSeqNo();
        long bytesBeforeUpload = this.segmentTracker.getUploadBytesSucceeded();
        long startTimeInNS = System.nanoTime();
        final AtomicBoolean successful = new AtomicBoolean(false);
        try {
            try {
                this.initializeRemoteDirectoryOnTermUpdate();
                if (this.isRefreshAfterCommit()) {
                    this.remoteDirectory.deleteStaleSegmentsAsync(this.indexShard.getRemoteStoreSettings().getMinRemoteSegmentMetadataFiles());
                }
                try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();){
                    final SegmentInfos segmentInfos = segmentInfosGatedCloseable.get();
                    final ReplicationCheckpoint checkpoint = this.indexShard.computeReplicationCheckpoint(segmentInfos);
                    if (checkpoint.getPrimaryTerm() != this.indexShard.getOperationPrimaryTerm()) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "primaryTerm mismatch during segments upload to remote store [%s] != [%s]", checkpoint.getPrimaryTerm(), this.indexShard.getOperationPrimaryTerm()));
                    }
                    final long lastRefreshedCheckpoint = ((InternalEngine)this.indexShard.getEngine()).lastRefreshedCheckpoint();
                    final Collection localSegmentsPostRefresh = segmentInfos.files(true);
                    final Map<String, Long> localSegmentsSizeMap = this.updateLocalSizeMapAndTracker(localSegmentsPostRefresh).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    CountDownLatch latch = new CountDownLatch(1);
                    LatchedActionListener<Void> segmentUploadsCompletedListener = new LatchedActionListener<Void>(new ActionListener<Void>(){

                        public void onResponse(Void unused) {
                            try {
                                RemoteStoreRefreshListener.this.logger.debug("New segments upload successful");
                                RemoteStoreRefreshListener.this.uploadMetadata(localSegmentsPostRefresh, segmentInfos, checkpoint);
                                RemoteStoreRefreshListener.this.logger.debug("Metadata upload successful");
                                RemoteStoreRefreshListener.this.clearStaleFilesFromLocalSegmentChecksumMap(localSegmentsPostRefresh);
                                RemoteStoreRefreshListener.this.onSuccessfulSegmentsSync(refreshTimeMs, refreshClockTimeMs, refreshSeqNo, lastRefreshedCheckpoint, localSegmentsSizeMap, checkpoint);
                                successful.set(true);
                            }
                            catch (Exception e) {
                                RemoteStoreRefreshListener.this.logger.warn("Exception in post new segment upload actions", (Throwable)e);
                            }
                        }

                        public void onFailure(Exception e) {
                            RemoteStoreRefreshListener.this.logger.warn("Exception while uploading new segments to the remote segment store", (Throwable)e);
                        }
                    }, latch);
                    this.uploadNewSegments(localSegmentsPostRefresh, localSegmentsSizeMap, segmentUploadsCompletedListener);
                    if (!latch.await(this.remoteStoreSettings.getClusterRemoteSegmentTransferTimeout().millis(), TimeUnit.MILLISECONDS)) {
                        throw new SegmentUploadFailedException("Timeout while waiting for remote segment transfer to complete");
                    }
                }
                catch (EngineException e) {
                    this.logger.warn("Exception while reading SegmentInfosSnapshot", (Throwable)((Object)e));
                }
            }
            catch (IOException e) {
                this.logger.warn("Exception while uploading new segments to the remote segment store", (Throwable)e);
            }
        }
        catch (Throwable t) {
            this.logger.error("Exception in RemoteStoreRefreshListener.afterRefresh()", t);
        }
        this.updateFinalStatusInSegmentTracker(successful.get(), bytesBeforeUpload, startTimeInNS);
        this.logger.debug("syncSegments runStatus={}", (Object)successful.get());
        return successful.get();
    }

    private void uploadNewSegments(Collection<String> localSegmentsPostRefresh, Map<String, Long> localSegmentsSizeMap, ActionListener<Void> segmentUploadsCompletedListener) {
        Collection filteredFiles = localSegmentsPostRefresh.stream().filter(file -> !this.skipUpload((String)file)).collect(Collectors.toList());
        Function<Map<String, Long>, UploadListener> uploadListenerFunction = sizeMap -> this.createUploadListener(localSegmentsSizeMap);
        this.remoteStoreUploader.uploadSegments(filteredFiles, localSegmentsSizeMap, segmentUploadsCompletedListener, uploadListenerFunction, this.isLowPriorityUpload());
    }

    private void clearStaleFilesFromLocalSegmentChecksumMap(Collection<String> localSegmentsPostRefresh) {
        this.localSegmentChecksumMap.keySet().stream().filter(file -> !localSegmentsPostRefresh.contains(file)).collect(Collectors.toSet()).forEach(this.localSegmentChecksumMap::remove);
    }

    private void beforeSegmentsSync() {
        this.segmentTracker.incrementTotalUploadsStarted();
    }

    private void onSuccessfulSegmentsSync(long refreshTimeMs, long refreshClockTimeMs, long refreshSeqNo, long lastRefreshedCheckpoint, Map<String, Long> localFileSizeMap, ReplicationCheckpoint checkpoint) {
        this.segmentTracker.setLatestUploadedFiles(localFileSizeMap.keySet());
        this.updateRemoteRefreshTimeAndSeqNo(refreshTimeMs, refreshClockTimeMs, refreshSeqNo);
        this.resetBackOffDelayIterator();
        this.indexShard.getEngine().translogManager().setMinSeqNoToKeep(lastRefreshedCheckpoint + 1L);
        this.checkpointPublisher.publish(this.indexShard, checkpoint);
        this.logger.debug("onSuccessfulSegmentsSync lastRefreshedCheckpoint={} checkpoint={}", (Object)lastRefreshedCheckpoint, (Object)checkpoint);
    }

    private void resetBackOffDelayIterator() {
        this.backoffDelayIterator = EXPONENTIAL_BACKOFF_POLICY.iterator();
    }

    @Override
    protected TimeValue getNextRetryInterval() {
        return this.backoffDelayIterator.next();
    }

    @Override
    protected String getRetryThreadPoolName() {
        return "remote_refresh_retry";
    }

    private boolean isRefreshAfterCommit() throws IOException {
        String lastCommittedLocalSegmentFileName = SegmentInfos.getLastCommitSegmentsFileName((Directory)this.storeDirectory);
        return lastCommittedLocalSegmentFileName != null && !this.remoteDirectory.containsFile(lastCommittedLocalSegmentFileName, this.getChecksumOfLocalFile(lastCommittedLocalSegmentFileName));
    }

    private boolean isRefreshAfterCommitSafe() {
        try {
            return this.isRefreshAfterCommit();
        }
        catch (Exception e) {
            this.logger.info("Exception occurred in isRefreshAfterCommitSafe", (Throwable)e);
            return false;
        }
    }

    void uploadMetadata(Collection<String> localSegmentsPostRefresh, SegmentInfos segmentInfos, ReplicationCheckpoint replicationCheckpoint) throws IOException {
        long maxSeqNo = ((InternalEngine)this.indexShard.getEngine()).currentOngoingRefreshCheckpoint();
        SegmentInfos segmentInfosSnapshot = segmentInfos.clone();
        Map userData = segmentInfosSnapshot.getUserData();
        userData.put("local_checkpoint", String.valueOf(maxSeqNo));
        userData.put("max_seq_no", Long.toString(maxSeqNo));
        segmentInfosSnapshot.setUserData(userData, false);
        Translog.TranslogGeneration translogGeneration = this.indexShard.getEngine().translogManager().getTranslogGeneration();
        if (translogGeneration == null) {
            throw new UnsupportedOperationException("Encountered null TranslogGeneration while uploading metadata to remote segment store");
        }
        long translogFileGeneration = translogGeneration.translogFileGeneration;
        this.remoteDirectory.uploadMetadata(localSegmentsPostRefresh, segmentInfosSnapshot, this.storeDirectory, translogFileGeneration, replicationCheckpoint, this.indexShard.getNodeId());
    }

    boolean isLowPriorityUpload() {
        return this.isLocalOrSnapshotRecoveryOrSeeding();
    }

    private boolean skipUpload(String file) {
        try {
            return EXCLUDE_FILES.contains(file) || this.remoteDirectory.containsFile(file, this.getChecksumOfLocalFile(file));
        }
        catch (IOException e) {
            this.logger.error("Exception while reading checksum of local segment file: {}, ignoring the exception and re-uploading the file", (Object)file);
            return false;
        }
    }

    private String getChecksumOfLocalFile(String file) throws IOException {
        if (!this.localSegmentChecksumMap.containsKey(file)) {
            try (IndexInput indexInput = this.storeDirectory.openInput(file, IOContext.READONCE);){
                String checksum = Long.toString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
                this.localSegmentChecksumMap.put(file, checksum);
            }
        }
        return this.localSegmentChecksumMap.get(file);
    }

    private void updateRemoteRefreshTimeAndSeqNo(long refreshTimeMs, long refreshClockTimeMs, long refreshSeqNo) {
        this.segmentTracker.updateRemoteRefreshClockTimeMs(refreshClockTimeMs);
        this.segmentTracker.updateRemoteRefreshTimeMs(refreshTimeMs);
        this.segmentTracker.updateRemoteRefreshSeqNo(refreshSeqNo);
    }

    private Map<String, Long> updateLocalSizeMapAndTracker(Collection<String> segmentFiles) {
        return this.segmentTracker.updateLatestLocalFileNameLengthMap(segmentFiles, (CheckedFunction<String, Long, IOException>)((CheckedFunction)arg_0 -> ((Directory)this.storeDirectory).fileLength(arg_0)));
    }

    private void updateFinalStatusInSegmentTracker(boolean uploadStatus, long bytesBeforeUpload, long startTimeInNS) {
        if (uploadStatus) {
            long bytesUploaded = this.segmentTracker.getUploadBytesSucceeded() - bytesBeforeUpload;
            long timeTakenInMS = TimeValue.nsecToMSec((long)(System.nanoTime() - startTimeInNS));
            this.segmentTracker.incrementTotalUploadsSucceeded();
            this.segmentTracker.updateUploadBytesMovingAverage(bytesUploaded);
            this.segmentTracker.updateUploadBytesPerSecMovingAverage(bytesUploaded * 1000L / Math.max(1L, timeTakenInMS));
            this.segmentTracker.updateUploadTimeMovingAverage(timeTakenInMS);
        } else {
            this.segmentTracker.incrementTotalUploadsFailed();
        }
    }

    private void initializeRemoteDirectoryOnTermUpdate() throws IOException {
        if (this.primaryTerm != this.indexShard.getOperationPrimaryTerm()) {
            this.logger.trace("primaryTerm update from={} to={}", (Object)this.primaryTerm, (Object)this.indexShard.getOperationPrimaryTerm());
            this.primaryTerm = this.indexShard.getOperationPrimaryTerm();
            RemoteSegmentMetadata uploadedMetadata = this.remoteDirectory.init();
            if (uploadedMetadata != null) {
                this.segmentTracker.setLatestUploadedFiles(uploadedMetadata.getMetadata().keySet());
            }
        }
    }

    private boolean isReadyForUpload() {
        boolean isReady;
        boolean bl = isReady = this.indexShard.isStartedPrimary() || this.isLocalOrSnapshotRecoveryOrSeeding();
        if (!isReady) {
            StringBuilder sb = new StringBuilder("Skipped syncing segments with");
            if (this.indexShard.getReplicationTracker() != null) {
                sb.append(" primaryMode=").append(this.indexShard.getReplicationTracker().isPrimaryMode());
            }
            if (this.indexShard.state() != null) {
                sb.append(" indexShardState=").append((Object)this.indexShard.state());
            }
            if (this.indexShard.getEngineOrNull() != null) {
                sb.append(" engineType=").append(this.indexShard.getEngine().getClass().getSimpleName());
            }
            if (this.indexShard.recoveryState() != null) {
                sb.append(" recoverySourceType=").append((Object)this.indexShard.recoveryState().getRecoverySource().getType());
                sb.append(" primary=").append(this.indexShard.shardRouting.primary());
            }
            this.logger.info(sb.toString());
        }
        return isReady;
    }

    boolean isLocalOrSnapshotRecoveryOrSeeding() {
        return this.indexShard.state() == IndexShardState.RECOVERING && this.indexShard.shardRouting.primary() && this.indexShard.recoveryState() != null && (this.indexShard.recoveryState().getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS || this.indexShard.recoveryState().getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT || this.indexShard.shouldSeedRemoteStore());
    }

    private UploadListener createUploadListener(final Map<String, Long> fileSizeMap) {
        return new UploadListener(){
            private long uploadStartTime = 0L;

            @Override
            public void beforeUpload(String file) {
                RemoteStoreRefreshListener.this.segmentTracker.addUploadBytesStarted((Long)fileSizeMap.get(file));
                this.uploadStartTime = System.currentTimeMillis();
            }

            @Override
            public void onSuccess(String file) {
                RemoteStoreRefreshListener.this.segmentTracker.addUploadBytesSucceeded((Long)fileSizeMap.get(file));
                RemoteStoreRefreshListener.this.segmentTracker.addToLatestUploadedFiles(file);
                RemoteStoreRefreshListener.this.segmentTracker.addUploadTimeInMillis(Math.max(1L, System.currentTimeMillis() - this.uploadStartTime));
            }

            @Override
            public void onFailure(String file) {
                RemoteStoreRefreshListener.this.segmentTracker.addUploadBytesFailed((Long)fileSizeMap.get(file));
                RemoteStoreRefreshListener.this.segmentTracker.addUploadTimeInMillis(Math.max(1L, System.currentTimeMillis() - this.uploadStartTime));
            }
        };
    }

    private boolean shardClosed() {
        return this.indexShard.state() == IndexShardState.CLOSED;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    protected boolean isRetryEnabled() {
        return true;
    }
}

