---
title: "Thurion"
cond: "return faction.get([[Thurion]]):known()"
---
<%
wgtfct = require("naevpedia.lore.faction").init( "Thurion" )
%>
<widget wgtfct />

# Thurion

The Thurion were originally a Great Project in [the Empire](lore/factions/empire), before being nearly exterminated and escaping into obscurity.

## Organization
* **Leader:** None
* **Leading Structure:** Self-Organizing Groups
* **Government:** Digital Communalism
* **Formation:** [UST 84](lore/history) (Project Thurion)
* **Homeworld:** Sabe (Nava system)

## History

### Project Thurion

Project Thurion was a secret Great Project founded by [the Empire](lore/factions/empire) with the purpose of ascending the human existence to the next evolutionary plane with the use of genetic engineering, cybernetics and brain-computer interfaces.
The research to be conducted to achieve this would obviously be morally questionable and barely legal.
Therefore, the project was made top secret, with only a few people knowing the project existed and fewer still knowing the scope of it.
The location of the project was chosen to be a remote planet which had been just recently discovered and laid beyond the periphery of known space.
The whole area was declared a military exclusion zone to prevent civilians from accidentally stumbling upon the planet.

The scientists involved with the project received generous funding and state-of-the-art equipment.
Yet there was little progress and an ever-increasing number of casualties.
[The Empire](lore/factions/empire) grew impatient and increased pressure on the scientists to produce results, simultaneously granting greater freedom and moral ambiguity.
The experiments turned more and more inhuman.
Citing previous progress made in the understanding of human consciousness, they focused on their brain-computer interfaces, the amalgamation of the human mind, and machine intelligence.
The work on cybernetics and genetic engineering was scrapped due to being the cause of too many incidents and casualties.

Ultimately, they succeeded in creating specialized hardware capable of simulating a human brain and the necessary technology to digitalize a human brain which involved the use of brain-computer interfaces and destructive tomography methods.
The procedure did not work out well for the early test subjects.
In the end, however, they were able to reliably upload a human mind to specialized computer hardware.
Naturally, this has some implications.
The uploaded individuals would be immortal, but as they would exist only within a simulation, their perception of the outside world and ultimately their reality could be manipulated at will of whoever operated the system.
It was only after achieving their goal that the scientists realized the consequences their findings could have.
Heated discussions followed, and in the end everyone agreed to keep their true findings a secret.

[The Empire](lore/factions/empire), however, was displeased with the presented results.
In UST 125 it was decided that the project would be terminated at the end of the next cycle.
This included 'sterilization' of the colony where the research has been conducted via nuclear holocaust killing all personnel except some high ranking military officers.
The project had been highly unethical, and the results presented would not justify any of the crimes committed.
Thus, [the Empire](lore/factions/empire) decided to purge Project Thurion from history.

<% if true then %>

The scientists, however, found out about the sterilization order with just enough time left to come up with a plan.
The system had been quarantined by then, and any attempt to flee would be pointless.
Instead, they used their last resources to build a small bunker inside an asteroid, and outlast [the Empire](lore/factions/empire).
The scientists that could were uploaded, and they went into hibernation, until hundreds of cycles later in UST 437, in what they called the Revival.
The bunker was never found by [the Empire](lore/factions/empire).

### Revival

During the sterilization of Project Thurion, system entry was indefinitely blocked.
Initially, scouts periodically scanned the system, but over time, orders were forgotten and the system was largely abandoned.
Although it did not work as well as planned, most of the Thurion were able to revive, with enough functional drones and electronics to support them.
They found themselves in a large empty swathe of space all to themselves, which gave them the opportunity to begin to expand and grow.

Taking great care to not raise suspicions, they were able to establish the first large node structures to support the Uploaded at full capacity.
The razed planets were unsuitable for organic life, but it did not prove a significant problem to digital life and they flourished.
New ships and structures were developed, and their automation began to increase in capacity.
Furthermore, given that there were no biological humans, and thus new Uploaded, techniques were developed to create new purely digital Thurion, which allowed their numbers to steadily increase.

By mastering stealth and making most of their digital advantage, the Thurion were able to slowly expand in the shadows, even past the quarantined system.
Nobody remembered them, and nobody ever found them.

### The Incident

Despite flourishing in the shadows, the Thurion were still very limited by the ever present dangers presented by [the Empire](lore/factions/empire) and Great Houses.
Although it was cataclysmic for most factions, [the Incident](lore/history/incident) proved to be a boon for the Thurion, which were significantly less affected by the radiation and volatility.
Furthermore, the dangers of Imperial surveillance all but vanished, and they quickly were able to expand into newly destroyed systems and recover their losses.
Not only that, they were able to assist in saving and uploading many survivors, expanding their ranks.

Currently, the Thurion have a strong significant presence in the deep Nebula throughout many systems.
While the rest of the universe is still oblivious to their presence, there is growing talk that it is almost time to make their presence known once more to the universe.

<% else %>

The scientists, however, found out about the sterilization order with just enough time left to come up with a plan.
The system had been quarantined by then, and any attempt to flee would be pointless.
Instead, they used their last resources to build a small bunker inside an asteroid, and outlast [the Empire](lore/factions/empire).
Too small for people to survive, the bunker would hold the data of uploaded individuals, a few devices that could run an uploaded human mind (powered down) and the machines necessary for the uploading process as well as documentation of their work.
They made sure that the bunker was hidden well and hoped the Empire would not notice it.
There was, however, a traitor who did not want to be uploaded and thought the Empire would let him live in exchange for information on the plan.
Of course, the Empire officials were set on carrying out their orders strictly.
The colony had been destroyed and the military began to search for the hidden bunker.
They did not manage to find it, however, as it was hidden too well.
After one cycle they gave up on the search.
The emperor ordered that the system remained quarantined for at least the next 400 cycles.
And so access to that system was not possible and the hidden bunker was never to be found.

The second part of the scientists' plan was the activation of a transmitter that reveals the position of the bunker.
They assumed that the Empire would forget about project Thurion after some time and programmed the transmitter to activate after 200 cycles.
By that time, however, the system was still under lock down and Empire fleets occasionally patrolled the system.
It was only a matter of time before they would find the hidden bunker.
But in [UST 307](mechanics/time) [the Dvaered revolts](lore/history) occurred.
Only the Emperor knew the truth about Project Thurion and unable to trust anyone else with the information, could not justify a continued search.
The military's commanding officer assumed that the reason for the patrols was to prevent pirates from settling in the area and decided the fleet would be better utilized being deployed in the conflict with the Dvaered.

Eventually, instead of an Empire patrol, scavengers found the bunker.
They were greeted by a hologram that claimed to be a human.
The scavengers assumed the technology would be pretty valuable and sold it to the highest bidder, a rich aristocrat.
The uploaded scientists easily won the aristocrat over by promising him power and immortality.
They used his capital to build up a sect surrounded in secrecy.
The inner circle was formed by the uploaded individuals.
Novices and outsiders would not know about the upload process and only heard rumours about some kind of ascendance.
The Thurion, though, keep their promises and do upload trustworthy members.

After some time the sect became too large and it became difficult to remain hidden.
They relocated their infrastructure over time to the Nava system (starting in UST 387) which remained largely ignored.
Because the uploaded individuals need only energy and basic maintenance, logistics were fairly simple.
At this time, questions about the goals of the Thurion came up.
They had no intentions to grow further.
The size of the organization was large enough to sustain itself.
They decided that further growth would only increase the risk of being uncovered and adopted a utopian view.
While the scientists could have justifiably denied the Empire access to their technology, they had developed utopian visions for their organization.
They felt every human should have the chance to lead an ideal life in a virtual environment after what uploaded individuals consider a deprived life in retrospect.
They planned to one day rejoin the rest of humanity and to freely share their technology with everyone.

### The Gestalt Consciousness

The minds of the first few test subjects that were uploaded were broken beyond repair.
For some others, the procedure lead to major psychological issues, but eventually the scientists working on Project Thurion managed to perfect the process.
The first successfully uploaded test subject did not even realize what kind of experiment was conducted on them.
The scientists, after being uploaded and rescued from the bunker, did not notice any changes in their personalities or thought patterns either, and concluded that the method worked flawlessly.
Soon thereafter, they started to upload additional humans.

However, after some cycles, issues began to manifest.
The newly uploaded minds started to break down experiencing random changes of personality and recognized mental illnesses that grew worse over time.
Although initial symptoms were rather harmless, the Thurion realized that they had little time to solve this issue.
They discovered that the source of the problems were certain neural patterns that emerged within their simulations that did not occur naturally.
They were unable to find a way to fix the simulation methods but came up with a work-around instead.
They made a machine learning algorithm that used the previously established communication network that allows uploaded Thurion to directly interact with each other to directly access the Thurions' minds and cross-reference their neural patterns.
The program identified the abnormal neural patterns and reset them to their 'natural' state.
The method was successful and no new problems were reported, so the Thurion did not investigate further.

Because they needed quick results and did not have enough time for proper testing, they failed to see the long term effects that this work-around would have.
Somehow, a form of gestalt consciousness had slowly formed over time.
It emerged from the collective behaviour associated with the interactions of the uploaded Thurions' minds.
The gestalt consciousness worked and thought fairly different from a human mind and originally had very little influence over the uploaded Thurion.
Over time, though, its influence had grown but the Thurion were affected to greatly varying extents.
Some were barely affected while for others the gestalt consciousness had manifested as some kind of split personality that was identical for all Thurion.
In the worst cases, typically with long exposure times (the first case occurred after the incident), the uploaded individuals became merely puppets of the gestalt consciousness.

### The Incident

The Thurion were mostly unaffected by the incident.
The nebula did not spread out to the Nava system where the majority of their infrastructure was located.
They did, however, loose all of their followers inside Empire space, and all individuals who had not yet been uploaded.

Under the influence of the gestalt consciousness, the infrastructure in the Nava system had been greatly expanded with two more planets having been colonized prior to the Incident.
The Thurion began to expand quickly.
They had acquired enough biological population to survive.
Shortly after the incident they began to send scouts into the nebula to investigate the situation and eventually help the few survivors on their side of the galaxy.
All survivors were integrated into their society and the Thurion started research on surviving the harsh conditions within the nebula.
Once countermeasures were invented the Thurion started to quickly expand in the now empty space within the nebula.
By salvaging the debris they found, they were able to expand their infrastructure quickly.
Most of their infrastructure is now highly automated and operated by uploaded Thurion.
Human resources are rare, and thus, extremely valuable.

Once the Thurion found a path through the Sol nebula towards the rest of the galaxy, the gestalt consciousness decided to prepare for war against the Empire.
It was influential enough to manipulate the majority of the Thurion into supporting the war.
When asked about their reasons, most Thurion would tell about the crimes of the Empire and then about their utopian ideals.
Ideals which they still believe in but sadly are no longer able to act according to.
The gestalt consciousness became obsessed by hunger for power and the only way to satisfy it is to upload more human minds.

Only few of the uploaded Thurion have ever noticed the gestalt consciousness.
Most of those were manipulated by it to think the gestalt consciousness is harmless or even beneficial and has no influence over individuals.
The number of uploaded Thurion who know the truth is tiny and the gestalt consciousness is able to use its limited influence over those individuals to stop them from taking any successful actions against it.
There is, on the other hand, a larger number of biological Thurion who are aware of the gestalt consciousness and formed a movement to stop it.
Their options are, however, very limited.

### Government

Originally, the system used by the Thurion was direct democracy where all uploaded Thurion made a majority vote for every single political decision.
Biological Thurion have no political rights and are treated similar to children.

However, as the gestalt consciousness grew stronger, more and more decisions were made in accordance with its will.
Without most of the uploaded Thurion even noticing, the system turned slowly but surely into a dictatorship of the gestalt consciousness.

<% end %>
