/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export.exemplars;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.prometheus.client.exemplars.DefaultExemplarSampler;
import io.prometheus.client.exemplars.ExemplarSampler;
import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;
import java.util.function.Function;

public class OpentelemetryExemplarSamplerProvider {
    @Produces
    public Optional<ExemplarSampler> exemplarSampler() {
        return Optional.of(new DefaultExemplarSampler(new SpanContextSupplier(){

            public String getTraceId() {
                return this.get(SpanContext::getTraceId);
            }

            public String getSpanId() {
                return this.get(SpanContext::getSpanId);
            }

            public boolean isSampled() {
                return Boolean.TRUE.equals(this.get(SpanContext::isSampled));
            }

            private <T> T get(Function<SpanContext, T> valueExtractor) {
                return Optional.ofNullable(Span.fromContextOrNull((Context)QuarkusContextStorage.INSTANCE.current())).map(Span::getSpanContext).map(valueExtractor).orElse(null);
            }
        }));
    }
}

