/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class TemplateManager {
    public static final String TEMPLATE_SCHEME = "template";
    public static final TemplateManager INSTANCE = new TemplateManager();

    public File existingTemplateFile(String filePath) {
        File userDefinedTemplateFile = new File(filePath);
        if (userDefinedTemplateFile.isAbsolute() && userDefinedTemplateFile.exists() && !userDefinedTemplateFile.isDirectory()) {
            return userDefinedTemplateFile;
        }
        File templateFile = this.templateFile(filePath);
        if (templateFile.exists()) {
            return templateFile;
        }
        return this.fallbackTemplate();
    }

    public File writeableTemplateFile(String location) {
        if (location == null) {
            return null;
        }
        try {
            URI uri = new URI(location);
            if ("file".equals(uri.getScheme())) {
                return Paths.get(uri).toFile();
            }
            if (TEMPLATE_SCHEME.equals(uri.getScheme())) {
                return new File(this.defaultUserTemplateDir(), uri.getPath().substring(1));
            }
        }
        catch (URISyntaxException e) {
            LogUtils.severe((Throwable)e);
        }
        return null;
    }

    private File fallbackTemplate() {
        ResourceController resourceController = ResourceController.getResourceController();
        String fallback = resourceController.getDefaultProperty("standard_template");
        File fallbackFile = this.templateFile(fallback);
        Objects.requireNonNull(fallbackFile);
        return fallbackFile;
    }

    private File templateFile(String filePath) {
        File defaultUserTemplateDir = this.defaultUserTemplateDir();
        for (File userTemplates : new File[]{defaultUserTemplateDir, this.defaultStandardTemplateDir()}) {
            File fullPath;
            if (!userTemplates.isDirectory() || !(fullPath = new File(userTemplates, filePath)).exists() || fullPath.isDirectory()) continue;
            return fullPath;
        }
        return new File(defaultUserTemplateDir, filePath);
    }

    public URI normalizeTemplateLocation(URI locationUri) {
        String normalizedLocation;
        String userTemplateLocation;
        if (!"file".equals(locationUri.getScheme())) {
            return locationUri;
        }
        String location = locationUri.toString();
        if (location.startsWith(userTemplateLocation = this.defaultUserTemplateDir().toURI().toString())) {
            normalizedLocation = "template:/" + location.substring(userTemplateLocation.length());
        } else {
            String standardTemplateLocation = this.defaultStandardTemplateDir().toURI().toString();
            if (location.startsWith(standardTemplateLocation)) {
                normalizedLocation = "template:/" + location.substring(standardTemplateLocation.length());
            } else {
                return locationUri;
            }
        }
        try {
            return new URI(normalizedLocation);
        }
        catch (URISyntaxException e) {
            LogUtils.severe((Throwable)e);
            return locationUri;
        }
    }

    public URI expandExistingTemplateLocation(String location) {
        try {
            return location == null ? null : this.expandExistingTemplateLocation(new URI(location));
        }
        catch (URISyntaxException e) {
            LogUtils.severe((Throwable)e);
            return null;
        }
    }

    public URI expandExistingTemplateLocation(URI locationUri) {
        if (locationUri == null || !TEMPLATE_SCHEME.equals(locationUri.getScheme())) {
            return locationUri;
        }
        String path = locationUri.getPath().substring(1);
        return this.existingTemplateFile(path).toURI();
    }

    public URI expandTemplateLocation(URI locationUri) {
        if (!TEMPLATE_SCHEME.equals(locationUri.getScheme())) {
            return locationUri;
        }
        String path = locationUri.getPath().substring(1);
        return this.templateFile(path).toURI();
    }

    public File defaultUserTemplateDir() {
        String userDir = ResourceController.getResourceController().getFreeplaneUserDirectory();
        File userTemplates = new File(userDir, "templates");
        return userTemplates;
    }

    public File defaultStandardTemplateDir() {
        String resourceBaseDir = ResourceController.getResourceController().getResourceBaseDir();
        File allUserTemplates = new File(resourceBaseDir, "templates");
        return allUserTemplates;
    }

    public TreeSet<String> collectAvailableMapTemplates() {
        TreeSet<String> templates = new TreeSet<String>();
        for (File dir : new File[]{this.defaultStandardTemplateDir(), this.defaultUserTemplateDir()}) {
            if (!dir.isDirectory()) continue;
            templates.addAll(Arrays.asList(dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".mm");
                }
            })));
        }
        return templates;
    }

    public String describeNormalizedLocation(URI location) {
        String followedMapPath;
        String message = TEMPLATE_SCHEME.equals(location.getScheme()) ? location.getPath().substring(1) : (followedMapPath = "file".equalsIgnoreCase(location.getScheme()) ? Paths.get(location).toFile().getAbsolutePath() : location.toString());
        return message;
    }

    public String describeNormalizedLocation(String location) {
        if (location == null) {
            return TextUtils.getText((String)"no_template_associated");
        }
        try {
            return this.describeNormalizedLocation(new URI(location));
        }
        catch (URISyntaxException e) {
            LogUtils.severe((Throwable)e);
            return TextUtils.getText((String)"no_template_associated");
        }
    }
}

