/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Polygon;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.shaped.border.AbstractPolygonBorder;

public class SlopedTabLineBorder
extends AbstractPolygonBorder {
    private static final long serialVersionUID = 1L;
    private static final int[][][] corners;
    private boolean drawBottomLine;
    private float leftSlope;
    private float rightSlope;
    private boolean bottomLeftRounded;
    private boolean topLeftRounded;
    private boolean topRightRounded;
    private boolean bottomRightRounded;
    private int leftHeight;
    private int rightHeight;
    private static int[] xCoords;
    private static int[] yCoords;
    private static int x;
    private static int y;
    private static int index;

    static {
        int[][][] nArrayArray = new int[6][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[2];
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[3] = -1;
        nArrayArray2[1] = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = -2;
        nArray2[2] = -1;
        nArray2[3] = -1;
        nArray2[5] = -1;
        nArrayArray2[2] = nArray2;
        int[] nArray3 = new int[12];
        nArray3[0] = -4;
        nArray3[2] = -3;
        nArray3[3] = -1;
        nArray3[4] = -2;
        nArray3[5] = -1;
        nArray3[6] = -1;
        nArray3[7] = -2;
        nArray3[8] = -1;
        nArray3[9] = -3;
        nArray3[11] = -4;
        nArrayArray2[3] = nArray3;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[2];
        nArrayArray3[1] = new int[2];
        int[] nArray4 = new int[6];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 2;
        nArrayArray3[2] = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = 4;
        nArray5[2] = 1;
        nArray5[3] = 3;
        nArray5[4] = 1;
        nArray5[5] = 2;
        nArray5[6] = 2;
        nArray5[7] = 1;
        nArray5[8] = 3;
        nArray5[9] = 1;
        nArray5[10] = 4;
        nArrayArray3[3] = nArray5;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        nArrayArray4[0] = new int[2];
        nArrayArray4[1] = new int[2];
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 1;
        nArrayArray4[2] = nArray6;
        int[] nArray7 = new int[12];
        nArray7[0] = -4;
        nArray7[2] = -3;
        nArray7[3] = 1;
        nArray7[4] = -2;
        nArray7[5] = 1;
        nArray7[6] = -1;
        nArray7[7] = 2;
        nArray7[8] = -1;
        nArray7[9] = 3;
        nArray7[11] = 4;
        nArrayArray4[3] = nArray7;
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[4][];
        nArrayArray5[0] = new int[2];
        int[] nArray8 = new int[4];
        nArray8[1] = -1;
        nArray8[2] = 1;
        nArrayArray5[1] = nArray8;
        int[] nArray9 = new int[6];
        nArray9[1] = -1;
        nArray9[2] = 1;
        nArray9[3] = -1;
        nArray9[4] = 2;
        nArrayArray5[2] = nArray9;
        int[] nArray10 = new int[12];
        nArray10[1] = -4;
        nArray10[2] = 1;
        nArray10[3] = -3;
        nArray10[4] = 1;
        nArray10[5] = -2;
        nArray10[6] = 2;
        nArray10[7] = -1;
        nArray10[8] = 3;
        nArray10[9] = -1;
        nArray10[10] = 4;
        nArrayArray5[3] = nArray10;
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[4][];
        nArrayArray6[0] = new int[2];
        nArrayArray6[1] = new int[2];
        int[] nArray11 = new int[6];
        nArray11[1] = 2;
        nArray11[2] = 1;
        nArray11[3] = 1;
        nArray11[4] = 1;
        nArrayArray6[2] = nArray11;
        int[] nArray12 = new int[12];
        nArray12[1] = 4;
        nArray12[2] = 1;
        nArray12[3] = 3;
        nArray12[4] = 1;
        nArray12[5] = 2;
        nArray12[6] = 2;
        nArray12[7] = 1;
        nArray12[8] = 3;
        nArray12[9] = 1;
        nArray12[10] = 4;
        nArrayArray6[3] = nArray12;
        nArrayArray[4] = nArrayArray6;
        int[][] nArrayArray7 = new int[4][];
        nArrayArray7[0] = new int[2];
        nArrayArray7[1] = new int[2];
        int[] nArray13 = new int[6];
        nArray13[0] = -1;
        nArray13[2] = -1;
        nArray13[3] = 1;
        nArray13[5] = 2;
        nArrayArray7[2] = nArray13;
        int[] nArray14 = new int[12];
        nArray14[0] = -4;
        nArray14[2] = -3;
        nArray14[3] = 1;
        nArray14[4] = -2;
        nArray14[5] = 1;
        nArray14[6] = -1;
        nArray14[7] = 2;
        nArray14[8] = -1;
        nArray14[9] = 3;
        nArray14[11] = 4;
        nArrayArray7[3] = nArray14;
        nArrayArray[5] = nArrayArray7;
        corners = nArrayArray;
        xCoords = new int[100];
        yCoords = new int[100];
    }

    public SlopedTabLineBorder() {
        this(0.0f, 1.0f);
    }

    public SlopedTabLineBorder(float leftSlope, float rightSlope) {
        this(leftSlope, rightSlope, 22, 22);
    }

    public SlopedTabLineBorder(float leftSlope, float rightSlope, int leftHeight, int rightHeight) {
        this(leftSlope, rightSlope, leftHeight, rightHeight, false, false, false, false);
    }

    public SlopedTabLineBorder(float leftSlope, float rightSlope, boolean bottomLeftRounded, boolean topLeftRounded, boolean topRightRounded, boolean bottomRightRounded) {
        this(leftSlope, rightSlope, 22, 22, bottomLeftRounded, topLeftRounded, topRightRounded, bottomRightRounded);
    }

    public SlopedTabLineBorder(float leftSlope, float rightSlope, int leftHeight, int rightHeight, boolean bottomLeftRounded, boolean topLeftRounded, boolean topRightRounded, boolean bottomRightRounded) {
        this(UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT, false, leftSlope, rightSlope, leftHeight, rightHeight, bottomLeftRounded, topLeftRounded, topRightRounded, bottomRightRounded);
    }

    public SlopedTabLineBorder(ColorProvider lineColor, ColorProvider highlightColor, boolean drawBottomLine, float leftSlope, float rightSlope, int leftHeight, int rightHeight, boolean bottomLeftRounded, boolean topLeftRounded, boolean topRightRounded, boolean bottomRightRounded) {
        super(lineColor, highlightColor);
        this.drawBottomLine = drawBottomLine;
        this.leftHeight = leftHeight;
        this.rightHeight = rightHeight;
        this.leftSlope = leftSlope;
        this.rightSlope = rightSlope;
        this.bottomLeftRounded = bottomLeftRounded;
        this.topLeftRounded = topLeftRounded;
        this.topRightRounded = topRightRounded;
        this.bottomRightRounded = bottomRightRounded;
    }

    @Override
    protected boolean lineIsDrawn(int index, Polygon polygon) {
        return this.drawBottomLine || index < polygon.npoints - 1;
    }

    @Override
    protected Insets getShapedBorderInsets(Component c) {
        return new Insets(1, (this.isBottomLeftRounded(c) ? 4 : 1) + (this.topLeftRounded ? (this.leftSlope <= 0.5f ? 4 : 1) : 0) + (int)(this.leftSlope * (float)this.leftHeight), this.drawBottomLine ? 1 : 0, (this.bottomRightRounded ? 4 : 1) + (this.topRightRounded ? (this.rightSlope <= 0.5f ? 4 : 1) : 0) + (int)(this.rightSlope * (float)this.rightHeight));
    }

    protected boolean isBottomLeftRounded(Component c) {
        return this.bottomLeftRounded;
    }

    private static int[] getCorner(int type, float slope, boolean rounded) {
        return corners[type][!rounded ? 0 : (type < 4 ? (slope >= 2.0f ? 1 : (slope >= 1.0f ? 2 : 3)) : (slope <= 0.5f ? 1 : (slope <= 1.0f ? 2 : 3)))];
    }

    private static void addPoint(int px, int py) {
        SlopedTabLineBorder.xCoords[SlopedTabLineBorder.index] = px;
        SlopedTabLineBorder.yCoords[SlopedTabLineBorder.index++] = py;
        x = px;
        y = py;
    }

    private static void addCorner(int px, int py, int[] c) {
        int i = 0;
        while (i < c.length) {
            SlopedTabLineBorder.addPoint(px + c[i++], py + c[i]);
            ++i;
        }
    }

    private static int getStartY(int[] corner) {
        return corner[1];
    }

    private static int getEndY(int[] corner) {
        return corner[corner.length - 1];
    }

    @Override
    protected Polygon createPolygon(Component c, int width, int height) {
        boolean bottomLeftRounded = this.isBottomLeftRounded(c);
        int leftX = (int)((float)this.leftHeight * this.leftSlope + (float)(bottomLeftRounded ? 4 : 0));
        int rightX = width - 1 - (int)((float)this.rightHeight * this.rightSlope + (float)(this.bottomRightRounded ? 4 : 0));
        int bottomY = height - (this.drawBottomLine ? 1 : 0);
        int[] topLeft = SlopedTabLineBorder.getCorner(1, this.leftSlope, this.topLeftRounded);
        int[] topRight = SlopedTabLineBorder.getCorner(2, this.rightSlope, this.topRightRounded);
        int[] bottomLeft = SlopedTabLineBorder.getCorner(0, this.leftSlope, bottomLeftRounded);
        int[] bottomRight = SlopedTabLineBorder.getCorner(3, this.rightSlope, this.bottomRightRounded);
        index = 0;
        y = bottomY;
        int dy = height - SlopedTabLineBorder.getStartY(topLeft) + SlopedTabLineBorder.getEndY(bottomLeft);
        if (dy <= this.leftHeight) {
            x = leftX - (int)((float)dy * this.leftSlope);
            SlopedTabLineBorder.addCorner(x, y, bottomLeft);
        } else {
            x = leftX - (int)((float)this.leftHeight * this.leftSlope);
            SlopedTabLineBorder.addCorner(x, y, SlopedTabLineBorder.getCorner(0, 0.0f, bottomLeftRounded));
            SlopedTabLineBorder.addPoint(x, SlopedTabLineBorder.getStartY(topLeft) + this.leftHeight);
        }
        SlopedTabLineBorder.addCorner(leftX, 0, topLeft);
        SlopedTabLineBorder.addCorner(rightX, 0, topRight);
        dy = height - SlopedTabLineBorder.getEndY(topRight) + SlopedTabLineBorder.getStartY(bottomRight);
        if (dy <= this.rightHeight) {
            SlopedTabLineBorder.addCorner((int)((float)rightX + (float)dy * this.rightSlope), bottomY, bottomRight);
        } else {
            SlopedTabLineBorder.addPoint((int)((float)rightX + this.rightSlope * (float)this.rightHeight), SlopedTabLineBorder.getEndY(topRight) + this.rightHeight);
            SlopedTabLineBorder.addCorner(x, bottomY, SlopedTabLineBorder.getCorner(3, 0.0f, this.bottomRightRounded));
        }
        return new Polygon(xCoords, yCoords, index);
    }
}

