/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.freeplane.features.commandsearch.SearchItem;

class ItemChecker {
    private static final int PATTERN_CACHE_SIZE = 10;
    private static final LinkedHashMap<String, Pattern> patterns = new LinkedHashMap<String, Pattern>(11){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() > 10;
        }
    };
    private final boolean shouldSearchWholeWords;

    public ItemChecker(boolean shouldSearchWholeWords) {
        this.shouldSearchWholeWords = shouldSearchWholeWords;
    }

    void findMatchingItems(List<? extends SearchItem> items, String[] searchTerms, Consumer<SearchItem> matches) {
        for (SearchItem searchItem : items) {
            if (!searchItem.checkAndMatch(searchTerms, this)) continue;
            matches.accept(searchItem);
        }
    }

    boolean contains(String text, String word) {
        if (this.shouldSearchWholeWords) {
            return this.containsWord(text, word);
        }
        return text.contains(word);
    }

    private boolean containsWord(String text, String word) {
        if (word.isEmpty()) {
            return false;
        }
        return patterns.computeIfAbsent(word, ItemChecker::compilePattern).matcher(text).find();
    }

    private static Pattern compilePattern(String word) {
        boolean startsWithLetter = Character.isAlphabetic(word.codePointAt(0));
        boolean endsWithLetter = Character.isAlphabetic(word.codePointBefore(word.length()));
        String startingWordBoundary = startsWithLetter ? "\\b" : "";
        String endingWordBoundary = endsWithLetter ? "\\b" : "";
        return Pattern.compile(startingWordBoundary + Pattern.quote(word) + endingWordBoundary);
    }
}

