/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public final class NativeClientLocationUtils {
    private static final Log log = Log.getLog(NativeClientLocationUtils.class);

    private NativeClientLocationUtils() {
    }

    public static Map<String, DBPNativeClientLocation> findLocalClientsOnUnix(Collection<String> extraFoldersToExamine, final Iterable<String> fileEndings, final Function<? super Path, ? extends DBPNativeClientLocation> grandparentPathToClientLocationMapper) {
        Collection<String> foldersToExamine = NativeClientLocationUtils.unixFoldersToExamine();
        foldersToExamine.addAll(extraFoldersToExamine);
        final HashMap<String, DBPNativeClientLocation> result = new HashMap<String, DBPNativeClientLocation>();
        for (String folder : foldersToExamine) {
            Path folderPath = Path.of(folder, new String[0]);
            if (Files.notExists(folderPath, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path grandparent;
                        if (!NativeClientLocationUtils.somethingEndsWith(file, fileEndings)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (Files.isExecutable(file) && (grandparent = NativeClientLocationUtils.getGrandparent(file.toRealPath(new LinkOption[0]))) != null) {
                            result.put(grandparent.toString(), (DBPNativeClientLocation)grandparentPathToClientLocationMapper.apply(grandparent));
                        }
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                });
            }
            catch (IOException e) {
                log.warn("Unable to examine folder %s while looking for a client home".formatted(folder), e);
            }
        }
        return result;
    }

    @NotNull
    private static Collection<String> unixFoldersToExamine() {
        ArrayList<String> foldersToExamine = new ArrayList<String>();
        foldersToExamine.add("/usr/bin");
        foldersToExamine.add("/usr/local/bin");
        if (RuntimeUtils.isLinux()) {
            foldersToExamine.add("/usr/lib");
            foldersToExamine.add("/etc/alternatives");
        } else if (RuntimeUtils.isMacOS()) {
            if (RuntimeUtils.isOSArchAMD64()) {
                foldersToExamine.add("/usr/local/Cellar/");
            } else if (RuntimeUtils.isOSArchAArch64()) {
                foldersToExamine.add("/opt/homebrew/bin");
                foldersToExamine.add("/opt/homebrew/Cellar");
                foldersToExamine.add("/opt/homebrew/opt");
            }
        }
        return foldersToExamine;
    }

    private static boolean somethingEndsWith(Path file, Iterable<String> fileEndings) {
        for (String endings : fileEndings) {
            if (!file.endsWith(endings)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Path getGrandparent(@NotNull Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getParent();
    }
}

