﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/NetworkInterface.h>
#include <aws/quicksight/model/VPCConnectionAvailabilityStatus.h>
#include <aws/quicksight/model/VPCConnectionResourceStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The summary metadata that describes a VPC connection.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/VPCConnectionSummary">AWS
 * API Reference</a></p>
 */
class VPCConnectionSummary {
 public:
  AWS_QUICKSIGHT_API VPCConnectionSummary() = default;
  AWS_QUICKSIGHT_API VPCConnectionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API VPCConnectionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the VPC connection that you're creating. This ID is a unique
   * identifier for each Amazon Web Services Region in an Amazon Web Services
   * account.</p>
   */
  inline const Aws::String& GetVPCConnectionId() const { return m_vPCConnectionId; }
  inline bool VPCConnectionIdHasBeenSet() const { return m_vPCConnectionIdHasBeenSet; }
  template <typename VPCConnectionIdT = Aws::String>
  void SetVPCConnectionId(VPCConnectionIdT&& value) {
    m_vPCConnectionIdHasBeenSet = true;
    m_vPCConnectionId = std::forward<VPCConnectionIdT>(value);
  }
  template <typename VPCConnectionIdT = Aws::String>
  VPCConnectionSummary& WithVPCConnectionId(VPCConnectionIdT&& value) {
    SetVPCConnectionId(std::forward<VPCConnectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the VPC connection.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  VPCConnectionSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The display name for the VPC connection.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  VPCConnectionSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon EC2 VPC ID associated with the VPC connection.</p>
   */
  inline const Aws::String& GetVPCId() const { return m_vPCId; }
  inline bool VPCIdHasBeenSet() const { return m_vPCIdHasBeenSet; }
  template <typename VPCIdT = Aws::String>
  void SetVPCId(VPCIdT&& value) {
    m_vPCIdHasBeenSet = true;
    m_vPCId = std::forward<VPCIdT>(value);
  }
  template <typename VPCIdT = Aws::String>
  VPCConnectionSummary& WithVPCId(VPCIdT&& value) {
    SetVPCId(std::forward<VPCIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon EC2 security group IDs associated with the VPC connection.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
  inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds = std::forward<SecurityGroupIdsT>(value);
  }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  VPCConnectionSummary& WithSecurityGroupIds(SecurityGroupIdsT&& value) {
    SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  template <typename SecurityGroupIdsT = Aws::String>
  VPCConnectionSummary& AddSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of IP addresses of DNS resolver endpoints for the VPC connection.</p>
   */
  inline const Aws::Vector<Aws::String>& GetDnsResolvers() const { return m_dnsResolvers; }
  inline bool DnsResolversHasBeenSet() const { return m_dnsResolversHasBeenSet; }
  template <typename DnsResolversT = Aws::Vector<Aws::String>>
  void SetDnsResolvers(DnsResolversT&& value) {
    m_dnsResolversHasBeenSet = true;
    m_dnsResolvers = std::forward<DnsResolversT>(value);
  }
  template <typename DnsResolversT = Aws::Vector<Aws::String>>
  VPCConnectionSummary& WithDnsResolvers(DnsResolversT&& value) {
    SetDnsResolvers(std::forward<DnsResolversT>(value));
    return *this;
  }
  template <typename DnsResolversT = Aws::String>
  VPCConnectionSummary& AddDnsResolvers(DnsResolversT&& value) {
    m_dnsResolversHasBeenSet = true;
    m_dnsResolvers.emplace_back(std::forward<DnsResolversT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the VPC connection.</p>
   */
  inline VPCConnectionResourceStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(VPCConnectionResourceStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline VPCConnectionSummary& WithStatus(VPCConnectionResourceStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The availability status of the VPC connection.</p>
   */
  inline VPCConnectionAvailabilityStatus GetAvailabilityStatus() const { return m_availabilityStatus; }
  inline bool AvailabilityStatusHasBeenSet() const { return m_availabilityStatusHasBeenSet; }
  inline void SetAvailabilityStatus(VPCConnectionAvailabilityStatus value) {
    m_availabilityStatusHasBeenSet = true;
    m_availabilityStatus = value;
  }
  inline VPCConnectionSummary& WithAvailabilityStatus(VPCConnectionAvailabilityStatus value) {
    SetAvailabilityStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of network interfaces.</p>
   */
  inline const Aws::Vector<NetworkInterface>& GetNetworkInterfaces() const { return m_networkInterfaces; }
  inline bool NetworkInterfacesHasBeenSet() const { return m_networkInterfacesHasBeenSet; }
  template <typename NetworkInterfacesT = Aws::Vector<NetworkInterface>>
  void SetNetworkInterfaces(NetworkInterfacesT&& value) {
    m_networkInterfacesHasBeenSet = true;
    m_networkInterfaces = std::forward<NetworkInterfacesT>(value);
  }
  template <typename NetworkInterfacesT = Aws::Vector<NetworkInterface>>
  VPCConnectionSummary& WithNetworkInterfaces(NetworkInterfacesT&& value) {
    SetNetworkInterfaces(std::forward<NetworkInterfacesT>(value));
    return *this;
  }
  template <typename NetworkInterfacesT = NetworkInterface>
  VPCConnectionSummary& AddNetworkInterfaces(NetworkInterfacesT&& value) {
    m_networkInterfacesHasBeenSet = true;
    m_networkInterfaces.emplace_back(std::forward<NetworkInterfacesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the IAM role associated with the VPC connection.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  VPCConnectionSummary& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the VPC connection was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  VPCConnectionSummary& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the VPC connection was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  VPCConnectionSummary& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vPCConnectionId;

  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_vPCId;

  Aws::Vector<Aws::String> m_securityGroupIds;

  Aws::Vector<Aws::String> m_dnsResolvers;

  VPCConnectionResourceStatus m_status{VPCConnectionResourceStatus::NOT_SET};

  VPCConnectionAvailabilityStatus m_availabilityStatus{VPCConnectionAvailabilityStatus::NOT_SET};

  Aws::Vector<NetworkInterface> m_networkInterfaces;

  Aws::String m_roleArn;

  Aws::Utils::DateTime m_createdTime{};

  Aws::Utils::DateTime m_lastUpdatedTime{};
  bool m_vPCConnectionIdHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_vPCIdHasBeenSet = false;
  bool m_securityGroupIdsHasBeenSet = false;
  bool m_dnsResolversHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_availabilityStatusHasBeenSet = false;
  bool m_networkInterfacesHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_createdTimeHasBeenSet = false;
  bool m_lastUpdatedTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
