/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Set;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.NameMapLookup;
import org.apache.calcite.schema.lookup.Named;
import org.apache.calcite.util.LazyReference;
import org.apache.calcite.util.NameMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SnapshotLookup<T>
implements Lookup<T> {
    private final Lookup<T> delegate;
    private LazyReference<Lookup<T>> cachedDelegate = new LazyReference();
    private boolean enabled = true;

    public SnapshotLookup(Lookup<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable T get(String name) {
        return this.delegate().get(name);
    }

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        return this.delegate().getIgnoreCase(name);
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        return this.delegate().getNames(pattern);
    }

    private Lookup<T> delegate() {
        if (!this.enabled) {
            return this.delegate;
        }
        return this.cachedDelegate.getOrCompute(() -> new NameMapLookup<T>(this.loadNameMap()));
    }

    private NameMap<T> loadNameMap() {
        NameMap<T> map = new NameMap<T>();
        for (String name : this.delegate.getNames(LikePattern.any())) {
            T entry = this.delegate.get(name);
            if (entry == null) continue;
            map.put(name, entry);
        }
        return map;
    }

    public void enable(boolean enabled) {
        if (!enabled) {
            this.cachedDelegate.reset();
        }
        this.enabled = enabled;
    }
}

