/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.Comparator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Functions;

public class BinarySearch {
    protected BinarySearch() {
    }

    public static <T> int lowerBound(T[] a, T key, Comparator<T> comparator) {
        return BinarySearch.lowerBound(a, key, 0, a.length - 1, Functions.identitySelector(), comparator);
    }

    public static <T> int upperBound(T[] a, T key, Comparator<T> comparator) {
        return BinarySearch.upperBound(a, key, 0, a.length - 1, Functions.identitySelector(), comparator);
    }

    public static <T, K> int lowerBound(T[] a, K key, Function1<T, K> keySelector, Comparator<K> comparator) {
        return BinarySearch.lowerBound(a, key, 0, a.length - 1, keySelector, comparator);
    }

    public static <T, K> int upperBound(T[] a, K key, Function1<T, K> keySelector, Comparator<K> comparator) {
        return BinarySearch.upperBound(a, key, 0, a.length - 1, keySelector, comparator);
    }

    public static <T> int lowerBound(T[] a, T key, int imin, int imax, Comparator<T> comparator) {
        return BinarySearch.lowerBound(a, key, imin, imax, Functions.identitySelector(), comparator);
    }

    public static <T> int upperBound(T[] a, T key, int imin, int imax, Comparator<T> comparator) {
        return BinarySearch.upperBound(a, key, imin, imax, Functions.identitySelector(), comparator);
    }

    public static <T, K> int lowerBound(T[] a, K key, int imin, int imax, Function1<T, K> keySelector, Comparator<K> comparator) {
        while (imin < imax) {
            int imid = imin + imax >>> 1;
            assert (imid < imax) : "search interval should be reduced min=" + imin + ", mid=" + imid + ", max=" + imax;
            if (comparator.compare(keySelector.apply(a[imid]), key) < 0) {
                imin = imid + 1;
                continue;
            }
            imax = imid;
        }
        if (imax != imin) {
            return -1;
        }
        int cmp = comparator.compare(keySelector.apply(a[imin]), key);
        if (cmp == 0) {
            return imin;
        }
        if (cmp < 0) {
            return imin + 1;
        }
        if (imin == 0) {
            return -1;
        }
        return imin;
    }

    public static <T, K> int upperBound(T[] a, K key, int imin, int imax, Function1<T, K> keySelector, Comparator<K> comparator) {
        int initialMax = imax;
        while (imin < imax) {
            int imid = imin + imax + 1 >>> 1;
            assert (imid > imin) : "search interval should be reduced min=" + imin + ", mid=" + imid + ", max=" + imax;
            if (comparator.compare(keySelector.apply(a[imid]), key) > 0) {
                imax = imid - 1;
                continue;
            }
            imin = imid;
        }
        if (imax != imin) {
            return -1;
        }
        int cmp = comparator.compare(keySelector.apply(a[imin]), key);
        if (cmp == 0) {
            return imin;
        }
        if (cmp > 0) {
            return imin - 1;
        }
        if (imin == initialMax) {
            return initialMax + 1;
        }
        return imin;
    }
}

