/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.jsonUDF;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class JsonExtractAllFunctionImpl
extends ImplementorUDF {
    private static final String ARRAY_SUFFIX = "{}";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public JsonExtractAllFunctionImpl() {
        super(new JsonExtractAllImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.explicit((RelDataType)OpenSearchTypeFactory.TYPE_FACTORY.createMapType(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY), true));
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})));
    }

    public static Object eval(Object ... args) {
        if (args.length < 1) {
            return null;
        }
        String jsonStr = JsonExtractAllFunctionImpl.getString(args[0]);
        return jsonStr != null ? JsonExtractAllFunctionImpl.convertEmptyMapToNull(JsonExtractAllFunctionImpl.parseJson(jsonStr)) : null;
    }

    private static Map<String, Object> convertEmptyMapToNull(Map<String, Object> map) {
        return map == null || map.isEmpty() ? null : map;
    }

    private static String getString(Object input) {
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof List) {
            return JsonExtractAllFunctionImpl.convertArrayToString((List)input);
        }
        return null;
    }

    private static String convertArrayToString(List<?> array) {
        if (array == null || array.isEmpty()) {
            return null;
        }
        return array.stream().filter(element -> element != null).map(Object::toString).collect(Collectors.joining());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> parseJson(String jsonStr) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Stack<String> pathStack = new Stack<String>();
        try (JsonParser parser = JSON_FACTORY.createParser(jsonStr);){
            JsonToken token;
            block16: while ((token = parser.nextToken()) != null) {
                switch (token) {
                    case START_OBJECT: {
                        continue block16;
                    }
                    case END_OBJECT: {
                        if (pathStack.isEmpty() || JsonExtractAllFunctionImpl.isInArray(pathStack)) continue block16;
                        pathStack.pop();
                        continue block16;
                    }
                    case START_ARRAY: {
                        pathStack.push(ARRAY_SUFFIX);
                        continue block16;
                    }
                    case END_ARRAY: {
                        pathStack.pop();
                        if (pathStack.isEmpty() || JsonExtractAllFunctionImpl.isInArray(pathStack)) continue block16;
                        pathStack.pop();
                        continue block16;
                    }
                    case FIELD_NAME: {
                        String fieldName = parser.currentName();
                        pathStack.push(fieldName);
                        continue block16;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_TRUE: 
                    case VALUE_FALSE: 
                    case VALUE_NULL: {
                        if (pathStack.isEmpty()) {
                            Map<String, Object> map = null;
                            return map;
                        }
                        JsonExtractAllFunctionImpl.appendValue(resultMap, JsonExtractAllFunctionImpl.buildPath(pathStack), JsonExtractAllFunctionImpl.extractValue(parser, token));
                        if (JsonExtractAllFunctionImpl.isInArray(pathStack)) continue block16;
                        pathStack.pop();
                        continue block16;
                    }
                }
            }
            return resultMap;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resultMap;
    }

    private static void appendValue(Map<String, Object> resultMap, String path, Object value) {
        Object existingValue = resultMap.get(path);
        if (existingValue == null) {
            resultMap.put(path, value);
        } else if (existingValue instanceof List) {
            ((List)existingValue).add(value);
        } else {
            resultMap.put(path, JsonExtractAllFunctionImpl.list(existingValue, value));
        }
    }

    private static List<Object> list(Object ... args) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object arg : args) {
            result.add(arg);
        }
        return result;
    }

    private static boolean isInArray(List<String> path) {
        return path.size() >= 1 && path.getLast().equals(ARRAY_SUFFIX);
    }

    private static Object extractValue(JsonParser parser, JsonToken token) throws IOException {
        switch (token) {
            case VALUE_STRING: {
                return parser.getValueAsString();
            }
            case VALUE_NUMBER_INT: {
                return JsonExtractAllFunctionImpl.getIntValue(parser);
            }
            case VALUE_NUMBER_FLOAT: {
                return parser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return parser.getValueAsString();
    }

    private static Object getIntValue(JsonParser parser) throws IOException {
        if (parser.getNumberType() == JsonParser.NumberType.INT) {
            return parser.getIntValue();
        }
        if (parser.getNumberType() == JsonParser.NumberType.LONG) {
            return parser.getLongValue();
        }
        return parser.getBigIntegerValue().doubleValue();
    }

    private static String buildPath(Collection<String> pathStack) {
        StringBuilder builder = new StringBuilder();
        for (String path : pathStack) {
            if (ARRAY_SUFFIX.equals(path)) {
                builder.append(ARRAY_SUFFIX);
                continue;
            }
            if (path.isEmpty()) continue;
            if (!builder.isEmpty()) {
                builder.append(".");
            }
            builder.append(path);
        }
        return builder.toString();
    }

    public static class JsonExtractAllImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ScalarFunctionImpl function = (ScalarFunctionImpl)ScalarFunctionImpl.create((Method)Types.lookupMethod(JsonExtractAllFunctionImpl.class, (String)"eval", (Class[])new Class[]{Object[].class}));
            return function.getImplementor().implement(translator, call, RexImpTable.NullAs.NULL);
        }
    }
}

