/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocol.proto.AliasMapProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.AliasMapProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.AliasMapProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryLevelDBAliasMapServer
implements InMemoryAliasMapProtocol,
Configurable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryLevelDBAliasMapServer.class);
    private final InMemoryAliasMap.CheckedFunction2<Configuration, String, InMemoryAliasMap> initFun;
    private RPC.Server aliasMapServer;
    private Configuration conf;
    private InMemoryAliasMap aliasMap;
    private String blockPoolId;

    public InMemoryLevelDBAliasMapServer(InMemoryAliasMap.CheckedFunction2<Configuration, String, InMemoryAliasMap> initFun, String blockPoolId) {
        this.initFun = initFun;
        this.blockPoolId = blockPoolId;
    }

    public void start() throws IOException {
        RPC.setProtocolEngine((Configuration)this.getConf(), AliasMapProtocolPB.class, ProtobufRpcEngine2.class);
        AliasMapProtocolServerSideTranslatorPB aliasMapProtocolXlator = new AliasMapProtocolServerSideTranslatorPB(this);
        BlockingService aliasMapProtocolService = AliasMapProtocolProtos.AliasMapProtocolService.newReflectiveBlockingService(aliasMapProtocolXlator);
        InetSocketAddress rpcAddress = DFSUtil.getBindAddress(this.conf, "dfs.provided.aliasmap.inmemory.dnrpc-address", "0.0.0.0:50200", "dfs.provided.aliasmap.inmemory.rpc.bind-host");
        boolean setVerbose = this.conf.getBoolean("dfs.provided.aliasmap.inmemory.server.log", false);
        this.aliasMapServer = new RPC.Builder(this.conf).setProtocol(AliasMapProtocolPB.class).setInstance((Object)aliasMapProtocolService).setBindAddress(rpcAddress.getHostName()).setPort(rpcAddress.getPort()).setNumHandlers(1).setVerbose(setVerbose).build();
        LOG.info("Starting InMemoryLevelDBAliasMapServer on {}", (Object)rpcAddress);
        this.aliasMapServer.start();
    }

    @Override
    public InMemoryAliasMapProtocol.IterationResult list(Optional<Block> marker) throws IOException {
        return this.aliasMap.list(marker);
    }

    @Override
    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block block) throws IOException {
        return this.aliasMap.read(block);
    }

    @Override
    public void write(@Nonnull Block block, @Nonnull ProvidedStorageLocation providedStorageLocation) throws IOException {
        this.aliasMap.write(block, providedStorageLocation);
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            this.aliasMap = this.initFun.apply(conf, this.blockPoolId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public InMemoryAliasMap getAliasMap() {
        return this.aliasMap;
    }

    @Override
    public void close() {
        LOG.info("Stopping InMemoryLevelDBAliasMapServer");
        try {
            if (this.aliasMap != null) {
                this.aliasMap.close();
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        if (this.aliasMapServer != null) {
            this.aliasMapServer.stop();
        }
    }
}

