/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.AlgorithmOperations;
import org.opensearch.client.opensearch.ml.ModelProfile;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeStatsDetails
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeStatsDetails> {
    @Nonnull
    private final Map<String, AlgorithmOperations> algorithms;
    @Nullable
    private final Long mlCircuitBreakerTriggerCount;
    @Nullable
    private final Long mlDeployedModelCount;
    @Nullable
    private final Long mlExecutingTaskCount;
    @Nullable
    private final Long mlFailureCount;
    @Nullable
    private final Long mlJvmHeapUsage;
    @Nullable
    private final Long mlRequestCount;
    @Nonnull
    private final Map<String, ModelProfile> models;
    public static final JsonpDeserializer<NodeStatsDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeStatsDetails::setupNodeStatsDetailsDeserializer);

    private NodeStatsDetails(Builder builder) {
        this.algorithms = ApiTypeHelper.unmodifiable(builder.algorithms);
        this.mlCircuitBreakerTriggerCount = builder.mlCircuitBreakerTriggerCount;
        this.mlDeployedModelCount = builder.mlDeployedModelCount;
        this.mlExecutingTaskCount = builder.mlExecutingTaskCount;
        this.mlFailureCount = builder.mlFailureCount;
        this.mlJvmHeapUsage = builder.mlJvmHeapUsage;
        this.mlRequestCount = builder.mlRequestCount;
        this.models = ApiTypeHelper.unmodifiable(builder.models);
    }

    public static NodeStatsDetails of(Function<Builder, ObjectBuilder<NodeStatsDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, AlgorithmOperations> algorithms() {
        return this.algorithms;
    }

    @Nullable
    public final Long mlCircuitBreakerTriggerCount() {
        return this.mlCircuitBreakerTriggerCount;
    }

    @Nullable
    public final Long mlDeployedModelCount() {
        return this.mlDeployedModelCount;
    }

    @Nullable
    public final Long mlExecutingTaskCount() {
        return this.mlExecutingTaskCount;
    }

    @Nullable
    public final Long mlFailureCount() {
        return this.mlFailureCount;
    }

    @Nullable
    public final Long mlJvmHeapUsage() {
        return this.mlJvmHeapUsage;
    }

    @Nullable
    public final Long mlRequestCount() {
        return this.mlRequestCount;
    }

    @Nonnull
    public final Map<String, ModelProfile> models() {
        return this.models;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.algorithms)) {
            generator.writeKey("algorithms");
            generator.writeStartObject();
            for (Map.Entry<String, AlgorithmOperations> entry : this.algorithms.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mlCircuitBreakerTriggerCount != null) {
            generator.writeKey("ml_circuit_breaker_trigger_count");
            generator.write(this.mlCircuitBreakerTriggerCount.longValue());
        }
        if (this.mlDeployedModelCount != null) {
            generator.writeKey("ml_deployed_model_count");
            generator.write(this.mlDeployedModelCount.longValue());
        }
        if (this.mlExecutingTaskCount != null) {
            generator.writeKey("ml_executing_task_count");
            generator.write(this.mlExecutingTaskCount.longValue());
        }
        if (this.mlFailureCount != null) {
            generator.writeKey("ml_failure_count");
            generator.write(this.mlFailureCount.longValue());
        }
        if (this.mlJvmHeapUsage != null) {
            generator.writeKey("ml_jvm_heap_usage");
            generator.write(this.mlJvmHeapUsage.longValue());
        }
        if (this.mlRequestCount != null) {
            generator.writeKey("ml_request_count");
            generator.write(this.mlRequestCount.longValue());
        }
        if (ApiTypeHelper.isDefined(this.models)) {
            generator.writeKey("models");
            generator.writeStartObject();
            for (Map.Entry<String, ToCopyableBuilder<AlgorithmOperations.Builder, AlgorithmOperations>> entry : this.models.entrySet()) {
                generator.writeKey(entry.getKey());
                ((ModelProfile)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeStatsDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::algorithms, JsonpDeserializer.stringMapDeserializer(AlgorithmOperations._DESERIALIZER), "algorithms");
        op.add(Builder::mlCircuitBreakerTriggerCount, JsonpDeserializer.longDeserializer(), "ml_circuit_breaker_trigger_count");
        op.add(Builder::mlDeployedModelCount, JsonpDeserializer.longDeserializer(), "ml_deployed_model_count");
        op.add(Builder::mlExecutingTaskCount, JsonpDeserializer.longDeserializer(), "ml_executing_task_count");
        op.add(Builder::mlFailureCount, JsonpDeserializer.longDeserializer(), "ml_failure_count");
        op.add(Builder::mlJvmHeapUsage, JsonpDeserializer.longDeserializer(), "ml_jvm_heap_usage");
        op.add(Builder::mlRequestCount, JsonpDeserializer.longDeserializer(), "ml_request_count");
        op.add(Builder::models, JsonpDeserializer.stringMapDeserializer(ModelProfile._DESERIALIZER), "models");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.algorithms);
        result = 31 * result + Objects.hashCode(this.mlCircuitBreakerTriggerCount);
        result = 31 * result + Objects.hashCode(this.mlDeployedModelCount);
        result = 31 * result + Objects.hashCode(this.mlExecutingTaskCount);
        result = 31 * result + Objects.hashCode(this.mlFailureCount);
        result = 31 * result + Objects.hashCode(this.mlJvmHeapUsage);
        result = 31 * result + Objects.hashCode(this.mlRequestCount);
        result = 31 * result + Objects.hashCode(this.models);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatsDetails other = (NodeStatsDetails)o;
        return Objects.equals(this.algorithms, other.algorithms) && Objects.equals(this.mlCircuitBreakerTriggerCount, other.mlCircuitBreakerTriggerCount) && Objects.equals(this.mlDeployedModelCount, other.mlDeployedModelCount) && Objects.equals(this.mlExecutingTaskCount, other.mlExecutingTaskCount) && Objects.equals(this.mlFailureCount, other.mlFailureCount) && Objects.equals(this.mlJvmHeapUsage, other.mlJvmHeapUsage) && Objects.equals(this.mlRequestCount, other.mlRequestCount) && Objects.equals(this.models, other.models);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeStatsDetails> {
        @Nullable
        private Map<String, AlgorithmOperations> algorithms;
        @Nullable
        private Long mlCircuitBreakerTriggerCount;
        @Nullable
        private Long mlDeployedModelCount;
        @Nullable
        private Long mlExecutingTaskCount;
        @Nullable
        private Long mlFailureCount;
        @Nullable
        private Long mlJvmHeapUsage;
        @Nullable
        private Long mlRequestCount;
        @Nullable
        private Map<String, ModelProfile> models;

        public Builder() {
        }

        private Builder(NodeStatsDetails o) {
            this.algorithms = Builder._mapCopy(o.algorithms);
            this.mlCircuitBreakerTriggerCount = o.mlCircuitBreakerTriggerCount;
            this.mlDeployedModelCount = o.mlDeployedModelCount;
            this.mlExecutingTaskCount = o.mlExecutingTaskCount;
            this.mlFailureCount = o.mlFailureCount;
            this.mlJvmHeapUsage = o.mlJvmHeapUsage;
            this.mlRequestCount = o.mlRequestCount;
            this.models = Builder._mapCopy(o.models);
        }

        private Builder(Builder o) {
            this.algorithms = Builder._mapCopy(o.algorithms);
            this.mlCircuitBreakerTriggerCount = o.mlCircuitBreakerTriggerCount;
            this.mlDeployedModelCount = o.mlDeployedModelCount;
            this.mlExecutingTaskCount = o.mlExecutingTaskCount;
            this.mlFailureCount = o.mlFailureCount;
            this.mlJvmHeapUsage = o.mlJvmHeapUsage;
            this.mlRequestCount = o.mlRequestCount;
            this.models = Builder._mapCopy(o.models);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder algorithms(Map<String, AlgorithmOperations> map) {
            this.algorithms = Builder._mapPutAll(this.algorithms, map);
            return this;
        }

        @Nonnull
        public final Builder algorithms(String key, AlgorithmOperations value) {
            this.algorithms = Builder._mapPut(this.algorithms, key, value);
            return this;
        }

        @Nonnull
        public final Builder algorithms(String key, Function<AlgorithmOperations.Builder, ObjectBuilder<AlgorithmOperations>> fn) {
            return this.algorithms(key, fn.apply(new AlgorithmOperations.Builder()).build());
        }

        @Nonnull
        public final Builder mlCircuitBreakerTriggerCount(@Nullable Long value) {
            this.mlCircuitBreakerTriggerCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlDeployedModelCount(@Nullable Long value) {
            this.mlDeployedModelCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlExecutingTaskCount(@Nullable Long value) {
            this.mlExecutingTaskCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlFailureCount(@Nullable Long value) {
            this.mlFailureCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlJvmHeapUsage(@Nullable Long value) {
            this.mlJvmHeapUsage = value;
            return this;
        }

        @Nonnull
        public final Builder mlRequestCount(@Nullable Long value) {
            this.mlRequestCount = value;
            return this;
        }

        @Nonnull
        public final Builder models(Map<String, ModelProfile> map) {
            this.models = Builder._mapPutAll(this.models, map);
            return this;
        }

        @Nonnull
        public final Builder models(String key, ModelProfile value) {
            this.models = Builder._mapPut(this.models, key, value);
            return this;
        }

        @Nonnull
        public final Builder models(String key, Function<ModelProfile.Builder, ObjectBuilder<ModelProfile>> fn) {
            return this.models(key, fn.apply(new ModelProfile.Builder()).build());
        }

        @Override
        @Nonnull
        public NodeStatsDetails build() {
            this._checkSingleUse();
            return new NodeStatsDetails(this);
        }
    }
}

