/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery;

import java.io.IOException;
import java.util.UUID;
import org.opensearch.common.inject.Inject;
import org.opensearch.sql.datasource.client.DataSourceClientFactory;
import org.opensearch.sql.datasource.client.exceptions.DataSourceClientException;
import org.opensearch.sql.datasource.query.QueryHandlerRegistry;
import org.opensearch.sql.directquery.DirectQueryExecutorService;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryRequest;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryResponse;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.GetDirectQueryResourcesResponse;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesRequest;
import org.opensearch.sql.directquery.rest.model.WriteDirectQueryResourcesResponse;

public class DirectQueryExecutorServiceImpl
implements DirectQueryExecutorService {
    private final DataSourceClientFactory dataSourceClientFactory;
    private final QueryHandlerRegistry queryHandlerRegistry;

    @Inject
    public DirectQueryExecutorServiceImpl(DataSourceClientFactory dataSourceClientFactory, QueryHandlerRegistry queryHandlerRegistry) {
        this.dataSourceClientFactory = dataSourceClientFactory;
        this.queryHandlerRegistry = queryHandlerRegistry;
    }

    @Override
    public ExecuteDirectQueryResponse executeDirectQuery(ExecuteDirectQueryRequest request) {
        Object result;
        String queryId = UUID.randomUUID().toString();
        String sessionId = request.getSessionId();
        String dataSourceName = request.getDataSources();
        String dataSourceType = null;
        try {
            dataSourceType = this.dataSourceClientFactory.getDataSourceType(dataSourceName).name().toLowerCase();
            Object client = this.dataSourceClientFactory.createClient(dataSourceName);
            result = this.queryHandlerRegistry.getQueryHandler(client).map(handler -> {
                try {
                    return handler.executeQuery(client, request);
                }
                catch (IOException e) {
                    return "{\"error\": \"Error executing query: " + e.getMessage() + "\"}";
                }
            }).orElse("{\"error\": \"Unsupported data source type\"}");
        }
        catch (Exception e) {
            result = "{\"error\": \"" + e.getMessage() + "\"}";
        }
        return new ExecuteDirectQueryResponse(queryId, (String)result, sessionId, dataSourceType);
    }

    @Override
    public GetDirectQueryResourcesResponse<?> getDirectQueryResources(GetDirectQueryResourcesRequest request) {
        Object client = this.dataSourceClientFactory.createClient(request.getDataSource());
        return this.queryHandlerRegistry.getQueryHandler(client).map(handler -> {
            try {
                return handler.getResources(client, request);
            }
            catch (IOException e) {
                throw new DataSourceClientException(String.format("Error retrieving resources for data source type: %s", request.getDataSource()), e);
            }
        }).orElseThrow(() -> new IllegalArgumentException("Unsupported data source type: " + request.getDataSource()));
    }

    @Override
    public WriteDirectQueryResourcesResponse<?> writeDirectQueryResources(WriteDirectQueryResourcesRequest request) {
        Object client = this.dataSourceClientFactory.createClient(request.getDataSource());
        return this.queryHandlerRegistry.getQueryHandler(client).map(handler -> {
            try {
                return handler.writeResources(client, request);
            }
            catch (IOException e) {
                throw new DataSourceClientException(String.format("Error writing resources for data source type: %s", request.getDataSource()), e);
            }
        }).orElseThrow(() -> new IllegalArgumentException("Unsupported data source type: " + request.getDataSource()));
    }
}

